/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="lset")
public class LSet
extends AbstractRedisOperation {
    public LSet(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key2 = this.params().get(0);
        int index = Utils.convertToInteger(this.params().get(1).toString());
        Slice element = this.params().get(2);
        if (!this.base().exists(key2)) {
            throw new IllegalArgumentException("ERR no such key");
        }
        List<Slice> storedData = this.base().getList(key2).getStoredData();
        if (index < 0) {
            index = storedData.size() + index;
        }
        if (index < 0 || index >= storedData.size()) {
            throw new IllegalArgumentException("ERR index out of range");
        }
        storedData.set(index, element);
        return Response.OK;
    }
}

