/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="ltrim")
class LTrim
extends AbstractRedisOperation {
    LTrim(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key2 = this.params().get(0);
        int start2 = Integer.parseInt(this.params().get(1).toString());
        int end2 = Integer.parseInt(this.params().get(2).toString());
        RMList listDBObj = this.getListFromBaseOrCreateEmpty(key2);
        List<Slice> list = listDBObj.getStoredData();
        int size2 = list.size();
        start2 = start2 < 0 ? size2 + start2 : start2;
        start2 = Math.max(start2, 0);
        int n = end2 = end2 < 0 ? size2 + end2 : end2;
        if (start2 > size2 || start2 > end2 || end2 < 0) {
            list.clear();
        } else {
            end2 = end2 >= size2 ? size2 : end2 + 1;
            list.subList(end2, list.size()).clear();
            list.subList(0, start2).clear();
        }
        return Response.OK;
    }
}

