/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.List;

abstract class ListPopper
extends AbstractRedisOperation {
    ListPopper(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    abstract Slice popper(List<Slice> var1);

    private Slice pop(Slice key2, List<Slice> list) {
        Slice result2 = this.popper(list);
        this.base().markKeyModified(key2);
        if (list.isEmpty()) {
            this.base().deleteValue(key2);
        }
        return result2;
    }

    @Override
    protected final Slice response() {
        Slice key2 = this.params().get(0);
        RMList listDBObj = this.getListFromBaseOrCreateEmpty(key2);
        List<Slice> list = listDBObj.getStoredData();
        if (list.isEmpty()) {
            return Response.NULL;
        }
        if (this.params().size() > 1) {
            Slice countParam = this.params().get(1);
            int count2 = Integer.parseInt(countParam.toString());
            if (count2 <= 0) {
                throw new WrongValueTypeException("value is out of range, must be positive");
            }
            ArrayList<Slice> responseList = new ArrayList<Slice>();
            while (count2 > 0 && list.size() > 0) {
                responseList.add(Response.bulkString(this.pop(key2, list)));
                --count2;
            }
            return Response.array(responseList);
        }
        return Response.bulkString(this.pop(key2, list));
    }
}

