/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.lists.LPush;
import com.github.fppt.jedismock.operations.lists.RPop;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.SliceParser;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RedisCommand(value="rpoplpush")
class RPopLPush
extends AbstractRedisOperation {
    private final OperationExecutorState state;

    RPopLPush(OperationExecutorState state, List<Slice> params) {
        super(state.base(), params);
        this.state = state;
    }

    @Override
    protected Slice response() {
        Slice source2 = this.params().get(0);
        Slice target = this.params().get(1);
        if (this.base().exists(target) && !(this.base().getValue(target) instanceof RMList)) {
            throw new IllegalArgumentException("WRONGTYPE Operation against a key holding the wrong kind of value");
        }
        Slice result2 = new RPop(this.base(), Collections.singletonList(source2)).execute();
        if (result2.equals(Response.NULL)) {
            return Response.NULL;
        }
        Slice valueToPush = SliceParser.consumeParameter(result2.data());
        new LPush(this.state, Arrays.asList(target, valueToPush)).execute();
        return result2;
    }
}

