/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.pubsub;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.stream.Collectors;

@RedisCommand(value="pubsub", transactional=false)
public class PubSub
extends AbstractRedisOperation {
    PubSub(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice subcommand = this.params().get(0);
        if ("channels".equalsIgnoreCase(subcommand.toString())) {
            String pattern2 = Utils.createRegexFromGlob(this.params().size() > 1 ? this.params().get(1).toString() : "*");
            return Response.array(this.base().getChannels().stream().filter(s2 -> s2.toString().matches(pattern2)).map(Response::bulkString).collect(Collectors.toList()));
        }
        if ("numpat".equalsIgnoreCase(subcommand.toString())) {
            return Response.integer(this.base().getNumpat());
        }
        return Response.error(String.format("Unsupported operation: pubsub %s", subcommand));
    }
}

