/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.pubsub;

import com.github.fppt.jedismock.RedisClient;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RedisCommand(value="publish")
class Publish
extends AbstractRedisOperation {
    Publish(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice channel2 = this.params().get(0);
        Slice message = this.params().get(1);
        Set<RedisClient> subscribers = this.base().getSubscribers(channel2);
        subscribers.forEach(subscriber -> {
            Slice response2 = Response.publishedMessage(channel2, message);
            subscriber.sendResponse(response2, "contacting subscriber");
        });
        Map<Slice, Set<RedisClient>> patternsPsubscribers = this.base().getPsubscribers(channel2);
        int totalClientsPsubscribed = patternsPsubscribers.entrySet().stream().map(mapEntry -> {
            Slice pattern2 = (Slice)mapEntry.getKey();
            Set psubscribedClients = (Set)mapEntry.getValue();
            psubscribedClients.forEach(psubscriber -> {
                Slice response2 = Response.publishedPMessage(pattern2, channel2, message);
                psubscriber.sendResponse(response2, "contacting subscriber");
            });
            return psubscribedClients.size();
        }).reduce(0, Integer::sum);
        return Response.integer(subscribers.size() + totalClientsPsubscribed);
    }
}

