/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.scripting;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.scripting.LuaRedisCallback;
import com.github.fppt.jedismock.operations.scripting.Script;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import com.github.fppt.jedismock.storage.RedisBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.JsePlatform;

@RedisCommand(value="eval")
public class Eval
extends AbstractRedisOperation {
    private static final String SCRIPT_RUNTIME_ERROR = "Error running script (call to function returned nil)";
    private static final String REDIS_LUA = Eval.loadResource();
    private final Globals globals = JsePlatform.standardGlobals();
    private final OperationExecutorState state;

    public Eval(RedisBase base, List<Slice> params, OperationExecutorState state) {
        super(base, params);
        this.state = state;
    }

    @Override
    protected int minArgs() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Slice response() {
        String script = this.params().get(0).toString();
        this.base().addCachedLuaScript(Script.getScriptSHA(script), script);
        int keysNum = Integer.parseInt(this.params().get(1).toString());
        List<LuaValue> args2 = Eval.getLuaValues(this.params().subList(2, this.params().size()));
        this.globals.set("unpack", (LuaValue)this.globals.load("return table.unpack(...)").checkfunction());
        this.globals.set("redis", (LuaValue)this.globals.load(REDIS_LUA).call().checktable());
        this.globals.set("KEYS", (LuaValue)Eval.embedLuaListToValue(args2.subList(0, keysNum)));
        this.globals.set("ARGV", (LuaValue)Eval.embedLuaListToValue(args2.subList(keysNum, args2.size())));
        this.globals.set("_mock", CoerceJavaToLua.coerce(new LuaRedisCallback(this.state)));
        int selected = this.state.getSelected();
        try {
            LuaValue result2 = this.globals.load(script).call();
            Slice slice = this.resolveResult(result2);
            return slice;
        }
        catch (LuaError e2) {
            Slice slice = Response.error(String.format("Error running script: %s", e2.getMessage()));
            return slice;
        }
        finally {
            this.state.changeActiveRedisBase(selected);
        }
    }

    private static List<LuaValue> getLuaValues(List<Slice> slices) {
        return slices.stream().map(Slice::data).map(LuaValue::valueOf).collect(Collectors.toList());
    }

    public static LuaTable embedLuaListToValue(List<LuaValue> luaValues) {
        return LuaValue.listOf(luaValues.toArray(new LuaValue[0]));
    }

    private Slice resolveResult(LuaValue result2) {
        if (result2.isnil()) {
            return Response.NULL;
        }
        switch (result2.typename()) {
            case "string": {
                return Response.bulkString(Slice.create(((LuaString)result2).m_bytes));
            }
            case "number": {
                return Response.integer(result2.tolong());
            }
            case "table": {
                if (!result2.get("err").isnil()) {
                    return Response.error(result2.get("err").tojstring());
                }
                if (!result2.get("ok").isnil()) {
                    return this.resolveResult(result2.get("ok"));
                }
                return Response.array(this.luaTableToList(result2));
            }
            case "boolean": {
                return result2.toboolean() ? Response.integer(1L) : Response.NULL;
            }
        }
        return Response.error(SCRIPT_RUNTIME_ERROR);
    }

    private ArrayList<Slice> luaTableToList(LuaValue result2) {
        ArrayList<Slice> list = new ArrayList<Slice>();
        for (int i2 = 0; i2 < result2.length(); ++i2) {
            list.add(this.resolveResult(result2.get(i2 + 1)));
        }
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String loadResource() {
        try (InputStream in = Eval.class.getResourceAsStream("/redis.lua");){
            String string;
            try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(in));){
                string = reader2.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }
}

