/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.scripting;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.CommandFactory;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.operations.connection.Select;
import com.github.fppt.jedismock.operations.scripting.Eval;
import com.github.fppt.jedismock.operations.scripting.Script;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisNoScriptException;
import redis.clients.jedis.util.RedisInputStream;

public class LuaRedisCallback {
    private static final Logger LOG = LoggerFactory.getLogger(LuaRedisCallback.class);
    private static final String NOSCRIPT_PREFIX = "NOSCRIPT ";
    private final OperationExecutorState state;

    public LuaRedisCallback(OperationExecutorState state) {
        this.state = state;
    }

    public LuaValue call(LuaValue args2) {
        String operationName = args2.get(1).tojstring();
        ArrayList<Slice> a2 = new ArrayList<Slice>();
        for (int i2 = 2; i2 <= args2.length(); ++i2) {
            LuaValue arg = args2.get(i2);
            if (arg instanceof LuaString) {
                a2.add(Slice.create(((LuaString)arg).m_bytes));
                continue;
            }
            a2.add(Slice.create(args2.get(i2).tojstring()));
        }
        return this.execute(operationName, a2);
    }

    public LuaValue pcall(LuaValue args2) {
        try {
            return this.call(args2);
        }
        catch (Exception e2) {
            LuaTable errorTable = new LuaTable();
            errorTable.set(LuaValue.valueOf("err"), (LuaValue)LuaValue.valueOf(e2.getMessage()));
            return errorTable;
        }
    }

    public String sha1hex(String x) {
        return Script.getScriptSHA(x);
    }

    public void log(int level, String message) {
        LOG.info("redis.log ({}, {})", (Object)level, (Object)message);
    }

    private LuaValue execute(String operationName, List<Slice> args2) {
        RedisOperation operation;
        RedisOperation redisOperation = operation = "select".equalsIgnoreCase(operationName) ? new Select(this.state, args2) : CommandFactory.buildOperation(operationName.toLowerCase(), true, this.state, args2);
        if (operation != null) {
            LuaRedisCallback.throwOnUnsupported(operation);
            Slice result2 = operation.execute();
            if (Response.NULL.equals(result2)) {
                return LuaValue.FALSE;
            }
            byte[] data2 = result2.data();
            return LuaRedisCallback.toLuaValue(new RedisInputStream(new ByteArrayInputStream(data2)));
        }
        throw new RuntimeException("Operation not implemented!");
    }

    private static void throwOnUnsupported(RedisOperation operation) {
        if (operation.getClass().equals(Eval.class)) {
            throw new RuntimeException("This Redis command is not allowed from scripts");
        }
    }

    private static LuaValue toLuaValue(RedisInputStream is) {
        byte b2 = is.readByte();
        switch (b2) {
            case 43: {
                return LuaValue.valueOf(LuaRedisCallback.processStatusCodeReply(is));
            }
            case 36: {
                return LuaValue.valueOf(LuaRedisCallback.processBulkReply(is));
            }
            case 42: {
                return Eval.embedLuaListToValue(LuaRedisCallback.processMultiBulkReply(is));
            }
            case 58: {
                return LuaValue.valueOf(LuaRedisCallback.processInteger(is).longValue());
            }
            case 45: {
                String message = is.readLine();
                if (message.startsWith(NOSCRIPT_PREFIX)) {
                    throw new JedisNoScriptException(message);
                }
                throw new JedisDataException(message);
            }
        }
        return LuaValue.NONE;
    }

    private static byte[] processStatusCodeReply(RedisInputStream is) {
        return is.readLineBytes();
    }

    private static byte[] processBulkReply(RedisInputStream is) {
        int size2;
        int len2 = is.readIntCrLf();
        if (len2 <= 0) {
            return new byte[0];
        }
        byte[] read2 = new byte[len2];
        for (int offset = 0; offset < len2; offset += size2) {
            size2 = is.read(read2, offset, len2 - offset);
            if (size2 != -1) continue;
            throw new RuntimeException("It seems like server has closed the connection.");
        }
        is.readByte();
        is.readByte();
        return read2;
    }

    private static Long processInteger(RedisInputStream is) {
        return is.readLongCrLf();
    }

    private static List<LuaValue> processMultiBulkReply(RedisInputStream is) {
        int num = is.readIntCrLf();
        if (num <= 0) {
            return Collections.emptyList();
        }
        ArrayList<LuaValue> ret = new ArrayList<LuaValue>(num);
        for (int i2 = 0; i2 < num; ++i2) {
            try {
                ret.add(LuaRedisCallback.toLuaValue(is));
                continue;
            }
            catch (JedisDataException e2) {
                System.err.println(e2.getMessage());
            }
        }
        return ret;
    }
}

