/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sets;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.sets.SAdd;
import com.github.fppt.jedismock.operations.sets.SRem;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.Arrays;
import java.util.List;

@RedisCommand(value="smove")
public class SMove
extends AbstractRedisOperation {
    SMove(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice src = this.params().get(0);
        Slice dest = this.params().get(1);
        Slice member = this.params().get(2);
        if (this.base().getValue(dest) != null && this.base().getSet(dest) == null) {
            throw new WrongValueTypeException("WRONGTYPE dest is not a set");
        }
        int result2 = new SRem(this.base(), Arrays.asList(src, member)).remove();
        if (result2 > 0 && !this.getSetFromBaseOrCreateEmpty(dest).getStoredData().contains(member)) {
            new SAdd(this.base(), Arrays.asList(dest, member)).execute();
        }
        return Response.integer(result2);
    }
}

