/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.ArgumentException;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

public abstract class AbstractByScoreOperation
extends AbstractRedisOperation {
    public AbstractByScoreOperation(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    public static double toDouble(String value2) {
        if ("nan".equalsIgnoreCase(value2)) {
            throw new ArgumentException("*ERR*weight*not*float*");
        }
        if ("+inf".equalsIgnoreCase(value2)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-inf".equalsIgnoreCase(value2)) {
            return Double.NEGATIVE_INFINITY;
        }
        try {
            return Double.parseDouble(value2);
        }
        catch (NumberFormatException e2) {
            throw new WrongValueTypeException("*ERR*not*float*");
        }
    }

    public Double getSum(Double score, String increment) {
        if ("+inf".equalsIgnoreCase(increment) || "infinity".equalsIgnoreCase(increment)) {
            if (score == Double.NEGATIVE_INFINITY) {
                throw new ArgumentException("ERR resulting score is not a number (NaN)");
            }
            return Double.POSITIVE_INFINITY;
        }
        if ("-inf".equalsIgnoreCase(increment) || "-infinity".equalsIgnoreCase(increment)) {
            if (score == Double.POSITIVE_INFINITY) {
                throw new ArgumentException("ERR resulting score is not a number (NaN)");
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (score.isInfinite()) {
            return score;
        }
        return score + AbstractByScoreOperation.toDouble(increment);
    }
}

