/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.ZSetEntry;
import com.github.fppt.jedismock.datastructures.ZSetEntryBound;
import com.github.fppt.jedismock.exception.ArgumentException;
import com.github.fppt.jedismock.operations.sortedsets.AbstractByScoreOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class AbstractZRange
extends AbstractByScoreOperation {
    protected static final String EXCLUSIVE_PREFIX = "(";
    protected static final String LOWEST_POSSIBLE_SCORE = "-inf";
    protected static final String HIGHEST_POSSIBLE_SCORE = "+inf";
    protected final EnumSet<Options> options = EnumSet.noneOf(Options.class);
    protected int startIndex;
    protected int endIndex;
    protected long offset = 0L;
    protected long count = 0L;
    protected Slice key;
    protected RMZSet mapDBObj;

    AbstractZRange(RedisBase base, List<Slice> params) {
        super(base, params);
        this.parseArgs();
    }

    protected abstract ZSetEntryBound getStartBound(Slice var1);

    protected abstract ZSetEntryBound getEndBound(Slice var1);

    protected NavigableSet<ZSetEntry> getRange(ZSetEntryBound start2, ZSetEntryBound end2) {
        if (this.mapDBObj.isEmpty()) {
            return Collections.emptyNavigableSet();
        }
        NavigableSet<ZSetEntry> subset = this.mapDBObj.subset(start2, end2);
        if (this.options.contains((Object)Options.REV)) {
            subset = subset.descendingSet();
        }
        return subset;
    }

    protected Slice getSliceFromRange(NavigableSet<ZSetEntry> entries2) {
        List<Slice> list = this.options.contains((Object)Options.LIMIT) ? (this.count == -1L ? (this.options.contains((Object)Options.WITHSCORES) ? entries2.stream().skip(this.offset).flatMap(AbstractZRange::getSliceStream).map(Response::bulkString).collect(Collectors.toList()) : entries2.stream().skip(this.offset).map(ZSetEntry::getValue).map(Response::bulkString).collect(Collectors.toList())) : (this.options.contains((Object)Options.WITHSCORES) ? entries2.stream().skip(this.offset).limit(this.count).flatMap(AbstractZRange::getSliceStream).map(Response::bulkString).collect(Collectors.toList()) : entries2.stream().skip(this.offset).limit(this.count).map(ZSetEntry::getValue).map(Response::bulkString).collect(Collectors.toList()))) : (this.options.contains((Object)Options.WITHSCORES) ? entries2.stream().flatMap(AbstractZRange::getSliceStream).map(Response::bulkString).collect(Collectors.toList()) : entries2.stream().map(ZSetEntry::getValue).map(Response::bulkString).collect(Collectors.toList()));
        return Response.array(list);
    }

    protected static Stream<Slice> getSliceStream(ZSetEntry e2) {
        if (e2.getScore() % 1.0 == 0.0) {
            return Stream.of(e2.getValue(), Slice.create(String.format("%.0f", e2.getScore())));
        }
        return Stream.of(e2.getValue(), Slice.create(String.valueOf(e2.getScore())));
    }

    protected final void parseArgs() {
        for (Slice param : this.params()) {
            for (Options value2 : Options.values()) {
                if (!value2.toString().equalsIgnoreCase(param.toString())) continue;
                this.options.add(value2);
                break;
            }
            if (!Options.LIMIT.toString().equalsIgnoreCase(param.toString())) continue;
            int index = this.params().indexOf(param);
            this.offset = Utils.convertToLong(this.params().get(++index).toString());
            this.count = Utils.convertToLong(this.params().get(++index).toString());
        }
    }

    protected Slice remRangeFromKey(NavigableSet<ZSetEntry> entries2) {
        int count2 = 0;
        for (ZSetEntry entry : new ArrayList<ZSetEntry>(entries2)) {
            this.mapDBObj.remove(entry.getValue());
            ++count2;
        }
        if (this.mapDBObj.isEmpty()) {
            this.base().deleteValue(this.key);
        } else {
            this.base().putValue(this.key, this.mapDBObj);
        }
        return Response.integer(count2);
    }

    protected final void expectNoOptions() {
        if (!this.options.isEmpty()) {
            throw new ArgumentException("*syntax*");
        }
    }

    static enum Options {
        WITHSCORES,
        REV,
        BYSCORE,
        BYLEX,
        LIMIT;

    }
}

