/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.ArgumentException;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.sortedsets.AbstractByScoreOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

@RedisCommand(value="zadd")
class ZAdd
extends AbstractByScoreOperation {
    private final Object lock;
    private final EnumSet<Options> options = EnumSet.noneOf(Options.class);
    private int countAdd = 0;
    private int countChange = 0;

    ZAdd(OperationExecutorState state, List<Slice> params) {
        super(state.base(), params);
        this.lock = state.lock();
    }

    @Override
    protected Slice response() {
        this.parseParams();
        if (this.options.contains((Object)Options.NX) && (this.options.contains((Object)Options.GT) || this.options.contains((Object)Options.LT) || this.options.contains((Object)Options.XX))) {
            throw new ArgumentException("ERR syntax error");
        }
        if (this.options.contains((Object)Options.LT) && this.options.contains((Object)Options.GT)) {
            throw new ArgumentException("ERR syntax error");
        }
        return this.options.contains((Object)Options.INCR) ? this.incr() : this.adding();
    }

    private Slice incr() {
        Slice key2 = this.params().get(0);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key2);
        if (this.params().size() != 3) {
            throw new ArgumentException("ERR INCR option supports a single increment-element pair");
        }
        String increment = this.params().get(1).toString();
        Slice member = this.params().get(2);
        double score = mapDBObj.getScore(member) == null ? 0.0 : mapDBObj.getScore(member);
        double newScore = this.getSum(score, increment);
        if (newScore != score) {
            this.addOneElement(mapDBObj, member, newScore);
            if (this.countChange + this.countAdd > 0) {
                mapDBObj.put(member, newScore);
                this.base().putValue(key2, mapDBObj);
                this.lock.notifyAll();
                return Response.bulkString(Slice.create(String.valueOf(newScore)));
            }
        }
        return Response.NULL;
    }

    private Slice adding() {
        Slice key2 = this.params().get(0);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key2);
        if ((this.params().size() & 1) == 0) {
            throw new ArgumentException("ERR syntax error");
        }
        if (this.options.contains((Object)Options.XX) && this.params().isEmpty()) {
            return Slice.empty();
        }
        for (int i2 = 1; i2 < this.params().size(); i2 += 2) {
            Slice score = this.params().get(i2);
            Slice value2 = this.params().get(i2 + 1);
            double newScore = ZAdd.toDouble(score.toString());
            this.addOneElement(mapDBObj, value2, newScore);
        }
        if (this.countAdd + this.countChange > 0) {
            this.base().putValue(key2, mapDBObj);
            this.lock.notifyAll();
        }
        return this.options.contains((Object)Options.CH) ? Response.integer(this.countAdd + this.countChange) : Response.integer(this.countAdd);
    }

    private void addOneElement(RMZSet mapDBObj, Slice value2, double newScore) {
        if (this.options.contains((Object)Options.XX) && mapDBObj.hasMember(value2)) {
            this.updateValue(mapDBObj, value2, newScore);
        }
        if (this.options.contains((Object)Options.NX) && !mapDBObj.hasMember(value2)) {
            mapDBObj.put(value2, newScore);
            ++this.countAdd;
        }
        if (!this.options.contains((Object)Options.XX) && !this.options.contains((Object)Options.NX)) {
            if (mapDBObj.hasMember(value2)) {
                this.updateValue(mapDBObj, value2, newScore);
            } else {
                mapDBObj.put(value2, newScore);
                ++this.countAdd;
            }
        }
    }

    private void updateValue(RMZSet mapDBObj, Slice value2, double newScore) {
        Double oldScore = mapDBObj.getScore(value2);
        if (this.options.contains((Object)Options.LT) && oldScore > newScore || this.options.contains((Object)Options.GT) && oldScore < newScore || !this.options.contains((Object)Options.LT) && !this.options.contains((Object)Options.GT) && oldScore != newScore) {
            mapDBObj.put(value2, newScore);
            ++this.countChange;
        }
    }

    private void parseParams() {
        Iterator<Slice> i2 = this.params().iterator();
        i2.next();
        boolean quit = false;
        block0: while (i2.hasNext() && !quit) {
            String opt = i2.next().toString();
            quit = true;
            for (Options value2 : Options.values()) {
                if (!value2.toString().equalsIgnoreCase(opt)) continue;
                this.options.add(value2);
                i2.remove();
                quit = false;
                continue block0;
            }
        }
    }

    static enum Options {
        XX,
        NX,
        LT,
        GT,
        CH,
        INCR;

    }
}

