/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.sortedsets.AbstractByScoreOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="zincrby")
public class ZIncrBy
extends AbstractByScoreOperation {
    public ZIncrBy(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected int minArgs() {
        return 3;
    }

    @Override
    protected int maxArgs() {
        return 3;
    }

    @Override
    protected Slice response() {
        return Response.bulkString(Slice.create(String.valueOf(this.getNewScore())));
    }

    protected double getNewScore() {
        Slice key2 = this.params().get(0);
        String increment = this.params().get(1).toString();
        Slice member = this.params().get(2);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key2);
        double score = mapDBObj.getScore(member) == null ? 0.0 : mapDBObj.getScore(member);
        double newScore = this.getSum(score, increment);
        mapDBObj.put(member, newScore);
        this.base().putValue(key2, mapDBObj);
        return newScore;
    }
}

