/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.ArgumentException;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.sortedsets.ZPop;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

@RedisCommand(value="zmpop")
public class ZMPop
extends ZPop {
    private final EnumSet<Options> options = EnumSet.noneOf(Options.class);
    private int numKeys = 1;
    private long count = 1L;

    ZMPop(RedisBase base, List<Slice> params) {
        super(base, params, false);
    }

    @Override
    protected int minArgs() {
        return 3;
    }

    @Override
    protected Slice response() {
        this.parseArgs();
        return this.getResult();
    }

    protected Slice getResult() {
        for (int i2 = 0; i2 < this.numKeys; ++i2) {
            Slice key2 = this.params().get(i2 + 1);
            RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key2);
            if (mapDBObj.isEmpty()) continue;
            ArrayList<Slice> newParams = new ArrayList<Slice>();
            newParams.add(key2);
            newParams.add(Slice.create(String.valueOf(Math.min(this.count, (long)mapDBObj.size()))));
            List<Slice> result2 = new ZPop(this.base(), newParams, this.options.contains((Object)Options.MAX)).pop();
            ArrayList<Slice> popedList = new ArrayList<Slice>();
            for (int index = 0; index < result2.size(); index += 2) {
                Slice value2 = result2.get(index);
                Slice score = result2.get(index + 1);
                popedList.add(Response.array(value2, score));
            }
            return Response.array(Response.bulkString(key2), Response.array(popedList));
        }
        return Response.NULL_ARRAY;
    }

    protected final List<Slice> parseArgs() {
        ArrayList<Slice> temp = new ArrayList<Slice>(this.params());
        for (Slice param : temp) {
            if (Options.MIN.toString().equalsIgnoreCase(param.toString())) {
                if (this.options.contains((Object)Options.MAX)) {
                    throw new ArgumentException("ERR syntax error*");
                }
                this.options.add(Options.MIN);
                this.params().remove(param);
                continue;
            }
            if (Options.MAX.toString().equalsIgnoreCase(param.toString())) {
                if (this.options.contains((Object)Options.MIN)) {
                    throw new ArgumentException("ERR syntax error*");
                }
                this.options.add(Options.MAX);
                this.params().remove(param);
                continue;
            }
            if (!Options.COUNT.toString().equalsIgnoreCase(param.toString())) continue;
            if (this.options.contains((Object)Options.COUNT)) {
                throw new ArgumentException("ERR syntax error*");
            }
            this.options.add(Options.COUNT);
            int index = this.params().indexOf(param);
            try {
                this.count = Long.parseLong(this.params().get(index + 1).toString());
            }
            catch (IndexOutOfBoundsException e2) {
                throw new ArgumentException("ERR syntax error*");
            }
            catch (NumberFormatException e3) {
                throw new ArgumentException("ERR count*");
            }
            if (this.count < 1L) {
                throw new ArgumentException("ERR count*");
            }
            this.params().remove(index + 1);
            this.params().remove(param);
        }
        try {
            this.numKeys = Integer.parseInt(this.params().get(0).toString());
        }
        catch (NumberFormatException e4) {
            throw new ArgumentException("ERR numkeys*");
        }
        if (this.numKeys < 1) {
            throw new ArgumentException("ERR numkeys*");
        }
        if (this.params().size() != this.numKeys + 1) {
            throw new ArgumentException("ERR syntax error*");
        }
        return this.params();
    }

    static enum Options {
        MIN,
        MAX,
        COUNT;

    }
}

