/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.List;

@RedisCommand(value="zmscore")
class ZMScore
extends AbstractRedisOperation {
    ZMScore(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected int minArgs() {
        return 2;
    }

    @Override
    protected Slice response() {
        Slice key2 = this.params().get(0);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key2);
        ArrayList<Slice> result2 = new ArrayList<Slice>();
        for (int i2 = 1; i2 < this.params().size(); ++i2) {
            Double score = mapDBObj.getScore(this.params().get(i2));
            result2.add(score == null ? Response.NULL : Response.bulkString(Slice.create(String.valueOf(Math.round(score)))));
        }
        return Response.array(result2);
    }
}

