/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.ZSetEntry;
import com.github.fppt.jedismock.exception.ArgumentException;
import com.github.fppt.jedismock.operations.sortedsets.AbstractByScoreOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ZPop
extends AbstractByScoreOperation {
    private final boolean isRev;

    ZPop(RedisBase base, List<Slice> params, boolean isRev) {
        super(base, params);
        this.isRev = isRev;
    }

    @Override
    protected Slice response() {
        return Response.array(this.pop());
    }

    protected List<Slice> pop() {
        int count2 = 1;
        if (this.params().size() > 1) {
            String newCount = this.params().get(1).toString();
            count2 = Integer.parseInt(newCount);
        }
        if (count2 < 0) {
            throw new ArgumentException("ERR value is out of range, must be positive");
        }
        Slice key2 = this.params().get(0);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key2);
        ArrayList<Slice> result2 = new ArrayList<Slice>();
        if (mapDBObj.isEmpty()) {
            return result2;
        }
        for (int i2 = 0; i2 < count2 && !mapDBObj.isEmpty(); ++i2) {
            ZSetEntry entry = (ZSetEntry)mapDBObj.entries(this.isRev).first();
            result2.addAll(Stream.of(entry.getValue(), Slice.create(String.format("%.0f", entry.getScore()))).map(Response::bulkString).collect(Collectors.toList()));
            mapDBObj.remove(entry.getValue());
        }
        if (mapDBObj.isEmpty()) {
            this.base().deleteValue(key2);
        }
        return result2;
    }
}

