/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.ZSetEntry;
import com.github.fppt.jedismock.exception.ArgumentException;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.sortedsets.AbstractZRange;
import com.github.fppt.jedismock.operations.sortedsets.AbstractZRangeByIndex;
import com.github.fppt.jedismock.operations.sortedsets.ZRangeByLex;
import com.github.fppt.jedismock.operations.sortedsets.ZRangeByScore;
import com.github.fppt.jedismock.operations.sortedsets.ZRevRange;
import com.github.fppt.jedismock.operations.sortedsets.ZRevRangeByLex;
import com.github.fppt.jedismock.operations.sortedsets.ZRevRangeByScore;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.NavigableSet;

@RedisCommand(value="zrange")
class ZRange
extends AbstractZRangeByIndex {
    ZRange(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        this.key = this.params().get(0);
        this.mapDBObj = this.getZSetFromBaseOrCreateEmpty(this.key);
        if (this.options.contains((Object)AbstractZRange.Options.BYSCORE) && !this.options.contains((Object)AbstractZRange.Options.REV)) {
            ZRangeByScore zRangeByScore = new ZRangeByScore(this.base(), this.params());
            return zRangeByScore.response();
        }
        if (this.options.contains((Object)AbstractZRange.Options.BYSCORE)) {
            ZRevRangeByScore zRevRangeByScore = new ZRevRangeByScore(this.base(), this.params());
            return zRevRangeByScore.response();
        }
        if (this.options.contains((Object)AbstractZRange.Options.BYLEX) && this.options.contains((Object)AbstractZRange.Options.WITHSCORES)) {
            throw new ArgumentException("ERR syntax error, WITHSCORES not supported in combination with BYLEX");
        }
        if (this.options.contains((Object)AbstractZRange.Options.BYLEX) && !this.options.contains((Object)AbstractZRange.Options.REV)) {
            ZRangeByLex zRangeByLex = new ZRangeByLex(this.base(), this.params());
            return zRangeByLex.response();
        }
        if (this.options.contains((Object)AbstractZRange.Options.BYLEX)) {
            ZRevRangeByLex zRevRangeByLex = new ZRevRangeByLex(this.base(), this.params());
            return zRevRangeByLex.response();
        }
        if (this.options.contains((Object)AbstractZRange.Options.LIMIT) && this.count != -1L) {
            throw new ArgumentException("ERR syntax error, LIMIT is only supported in combination with either BYSCORE or BYLEX");
        }
        if (this.options.contains((Object)AbstractZRange.Options.REV)) {
            ZRevRange zRevRange = new ZRevRange(this.base(), this.params());
            return zRevRange.response();
        }
        if (this.checkWrongIndex()) {
            return Response.EMPTY_ARRAY;
        }
        NavigableSet<ZSetEntry> entries2 = this.getRange(this.getStartBound(Slice.create(String.valueOf(this.startIndex))), this.getEndBound(Slice.create(String.valueOf(this.endIndex))));
        return this.getSliceFromRange(entries2);
    }
}

