/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.ZSetEntry;
import com.github.fppt.jedismock.exception.ArgumentException;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.sortedsets.AbstractZRange;
import com.github.fppt.jedismock.operations.sortedsets.AbstractZRangeByIndex;
import com.github.fppt.jedismock.operations.sortedsets.ZRangeByLex;
import com.github.fppt.jedismock.operations.sortedsets.ZRangeByScore;
import com.github.fppt.jedismock.operations.sortedsets.ZRevRangeByLex;
import com.github.fppt.jedismock.operations.sortedsets.ZRevRangeByScore;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;

@RedisCommand(value="zrangestore")
class ZRangeStore
extends AbstractZRangeByIndex {
    private final Object lock;

    ZRangeStore(OperationExecutorState state, List<Slice> params) {
        super(state.base(), params);
        this.lock = state.lock();
    }

    @Override
    protected Slice response() {
        if (this.options.contains((Object)AbstractZRange.Options.WITHSCORES)) {
            throw new ArgumentException("*syntax*");
        }
        Slice keyDest = this.params().get(0);
        this.params().remove(0);
        this.key = this.params().get(0);
        if (!this.base().exists(this.key)) {
            this.base().deleteValue(keyDest);
            return Response.integer(0L);
        }
        this.mapDBObj = this.base().getZSet(this.key);
        if (this.options.contains((Object)AbstractZRange.Options.BYSCORE) && !this.options.contains((Object)AbstractZRange.Options.REV)) {
            ZRangeByScore zRangeByScore = new ZRangeByScore(this.base(), new ArrayList<Slice>());
            zRangeByScore.key = this.key;
            zRangeByScore.mapDBObj = this.mapDBObj;
            return this.saveToNewKey(keyDest, zRangeByScore.getRange(zRangeByScore.getStartBound(this.params().get(1)), zRangeByScore.getEndBound(this.params().get(2))));
        }
        if (this.options.contains((Object)AbstractZRange.Options.BYSCORE)) {
            ZRevRangeByScore zRevRangeByScore = new ZRevRangeByScore(this.base(), new ArrayList<Slice>());
            zRevRangeByScore.key = this.key;
            zRevRangeByScore.mapDBObj = this.mapDBObj;
            zRevRangeByScore.options.add(AbstractZRange.Options.REV);
            return this.saveToNewKey(keyDest, zRevRangeByScore.getRange(zRevRangeByScore.getStartBound(this.params().get(2)), zRevRangeByScore.getEndBound(this.params().get(1))));
        }
        if (this.options.contains((Object)AbstractZRange.Options.BYLEX) && !this.options.contains((Object)AbstractZRange.Options.REV)) {
            ZRangeByLex zRangeByLex = new ZRangeByLex(this.base(), new ArrayList<Slice>());
            zRangeByLex.key = this.key;
            zRangeByLex.mapDBObj = this.mapDBObj;
            return this.saveToNewKey(keyDest, zRangeByLex.getRange(zRangeByLex.getStartBound(this.params().get(1)), zRangeByLex.getEndBound(this.params().get(2))));
        }
        if (this.options.contains((Object)AbstractZRange.Options.BYLEX)) {
            ZRevRangeByLex zRevRangeByLex = new ZRevRangeByLex(this.base(), new ArrayList<Slice>());
            zRevRangeByLex.key = this.key;
            zRevRangeByLex.mapDBObj = this.mapDBObj;
            zRevRangeByLex.options.add(AbstractZRange.Options.REV);
            return this.saveToNewKey(keyDest, zRevRangeByLex.getRange(zRevRangeByLex.getStartBound(this.params().get(2)), zRevRangeByLex.getEndBound(this.params().get(1))));
        }
        if (this.options.contains((Object)AbstractZRange.Options.LIMIT)) {
            throw new ArgumentException("ERR syntax error, LIMIT is only supported in combination with either BYSCORE or BYLEX");
        }
        if (this.checkWrongIndex()) {
            this.base().deleteValue(keyDest);
            return Response.integer(0L);
        }
        NavigableSet<ZSetEntry> entries2 = this.getRange(this.getStartBound(Slice.create(String.valueOf(this.startIndex))), this.getStartBound(Slice.create(String.valueOf(this.endIndex))));
        return this.saveToNewKey(keyDest, entries2);
    }

    private Slice saveToNewKey(Slice keyDest, NavigableSet<ZSetEntry> entries2) {
        RMZSet resultZSet = new RMZSet();
        if (this.options.contains((Object)AbstractZRange.Options.LIMIT)) {
            int tempOffset = 0;
            int tempCount = 0;
            for (ZSetEntry entry : entries2) {
                if ((long)tempOffset < this.offset) {
                    ++tempOffset;
                    continue;
                }
                if (this.count == -1L) {
                    resultZSet.put(entry.getValue(), entry.getScore());
                    continue;
                }
                if ((long)tempCount < this.count) {
                    resultZSet.put(entry.getValue(), entry.getScore());
                    ++tempCount;
                    continue;
                }
                break;
            }
        } else {
            for (ZSetEntry entry : entries2) {
                resultZSet.put(entry.getValue(), entry.getScore());
            }
        }
        this.base().deleteValue(keyDest);
        if (resultZSet.size() > 0) {
            this.base().putValue(keyDest, resultZSet);
            this.lock.notifyAll();
        }
        return Response.integer(resultZSet.size());
    }
}

