/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.ZSetEntry;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.sortedsets.AbstractByScoreOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@RedisCommand(value="zrank")
public class ZRank
extends AbstractByScoreOperation {
    private static final String WITH_SCORES = "WITHSCORE";
    private static final String IS_REV = "REV";
    private boolean withScores = false;
    private boolean isRev = false;

    ZRank(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key2 = this.params().get(0);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key2);
        Slice member = this.params().get(1);
        this.parseArgs();
        if (!mapDBObj.hasMember(member)) {
            return this.withScores ? Response.NULL_ARRAY : Response.NULL;
        }
        int rank = mapDBObj.entries(this.isRev).headSet(new ZSetEntry(mapDBObj.getScore(member), member)).size();
        return this.withScores ? Response.array(Stream.of(Response.integer(rank), Response.integer(Math.round(mapDBObj.getScore(member)))).collect(Collectors.toList())) : Response.integer(rank);
    }

    private void parseArgs() {
        for (Slice param : this.params()) {
            if (WITH_SCORES.equalsIgnoreCase(param.toString())) {
                this.withScores = true;
            }
            if (!IS_REV.equalsIgnoreCase(param.toString())) continue;
            this.isRev = true;
        }
    }
}

