/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.ZSetEntry;
import com.github.fppt.jedismock.exception.ArgumentException;
import com.github.fppt.jedismock.operations.sortedsets.AbstractByScoreOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class ZStore
extends AbstractByScoreOperation {
    protected static final String IS_WEIGHTS = "WEIGHTS";
    protected static final String IS_AGGREGATE = "AGGREGATE";
    protected static final String IS_WITHSCORES = "WITHSCORES";
    protected static final String IS_LIMIT = "LIMIT";
    protected boolean isLimit = false;
    protected long limit = 0L;
    protected int startKeysIndex = 0;
    protected ArrayList<Double> weights;
    protected BiFunction<Double, Double, Double> aggregate = ZStore.getSum();
    protected boolean withScores = false;
    private final Object lock;

    ZStore(OperationExecutorState state, List<Slice> params) {
        super(state.base(), params);
        this.lock = state.lock();
    }

    protected abstract RMZSet getResult(RMZSet var1, RMZSet var2, double var3);

    protected RMZSet getFinishedZSet() {
        int numKeys = Integer.parseInt(this.params().get(this.startKeysIndex).toString());
        if (numKeys == 0) {
            throw new ArgumentException("*at least 1 input key * '" + this.getClass().getSimpleName().toLowerCase() + "' command");
        }
        this.parseParams(numKeys);
        if (this.params().size() != numKeys + this.startKeysIndex + 1) {
            throw new ArgumentException("ERR syntax error*");
        }
        RMZSet mapDBObj = new RMZSet();
        RMZSet temp = this.getZSet(this.params().get(this.startKeysIndex + 1));
        for (ZSetEntry entry : temp.entries(false)) {
            mapDBObj.put(entry.getValue(), ZStore.getMultiple(entry.getScore(), this.weights.get(0)));
        }
        for (int i2 = 1; i2 < numKeys; ++i2) {
            mapDBObj = this.getResult(mapDBObj, this.getZSet(this.params().get(this.startKeysIndex + i2 + 1)), this.weights.get(i2));
        }
        return mapDBObj;
    }

    private RMZSet getZSet(Slice setName) {
        if (this.base().exists(setName)) {
            String typeName2 = this.base().getValue(setName).getTypeName();
            if ("zset".equalsIgnoreCase(typeName2)) {
                return this.base().getZSet(setName);
            }
            if ("set".equalsIgnoreCase(typeName2)) {
                RMZSet result2 = new RMZSet();
                for (Slice value2 : this.base().getSet(setName).getStoredData()) {
                    result2.put(value2, 1.0);
                }
                return result2;
            }
        }
        return new RMZSet();
    }

    private void parseParams(int numKeys) {
        this.weights = new ArrayList(numKeys);
        for (int i2 = 0; i2 < numKeys; ++i2) {
            this.weights.add(1.0);
        }
        ArrayList<Slice> temp = new ArrayList<Slice>(this.params());
        for (Slice param : temp) {
            if (IS_WEIGHTS.equalsIgnoreCase(param.toString())) {
                int index = this.params().indexOf(param);
                for (int i3 = 0; i3 < numKeys; ++i3) {
                    double weight;
                    try {
                        weight = ZStore.toDouble(this.params().get(index + 1).toString());
                    }
                    catch (IndexOutOfBoundsException e2) {
                        throw new ArgumentException("ERR syntax error*");
                    }
                    this.weights.set(i3, weight);
                    this.params().remove(index + 1);
                }
                this.params().remove(param);
            }
            if (IS_AGGREGATE.equalsIgnoreCase(param.toString())) {
                String aggParam;
                try {
                    aggParam = this.params().get(this.params().indexOf(param) + 1).toString();
                }
                catch (IndexOutOfBoundsException e3) {
                    throw new ArgumentException("ERR syntax error*");
                }
                if ("MIN".equalsIgnoreCase(aggParam)) {
                    this.aggregate = Double::min;
                }
                if ("MAX".equalsIgnoreCase(aggParam)) {
                    this.aggregate = Double::max;
                }
                if ("SUM".equalsIgnoreCase(aggParam)) {
                    this.aggregate = ZStore.getSum();
                }
                this.params().remove(this.params().indexOf(param) + 1);
                this.params().remove(param);
            }
            if (IS_WITHSCORES.equalsIgnoreCase(param.toString())) {
                this.withScores = true;
                if (this.getClass().getSimpleName().endsWith("Store")) {
                    throw new ArgumentException("ERR syntax error");
                }
                this.params().remove(param);
            }
            if (!IS_LIMIT.equalsIgnoreCase(param.toString())) continue;
            this.isLimit = true;
            try {
                this.limit = Long.parseLong(this.params().get(this.params().indexOf(param) + 1).toString());
            }
            catch (IndexOutOfBoundsException e4) {
                throw new ArgumentException("ERR syntax error*");
            }
            catch (NumberFormatException e5) {
                throw new ArgumentException("ERR LIMIT*");
            }
            if (this.limit < 0L) {
                throw new ArgumentException("ERR LIMIT* Negative limit");
            }
            this.params().remove(this.params().indexOf(param) + 1);
            this.params().remove(param);
        }
    }

    private static BiFunction<Double, Double, Double> getSum() {
        return (a2, b2) -> {
            if (a2.isInfinite() && b2.isInfinite()) {
                if (a2.equals(b2)) {
                    return a2;
                }
                return 0.0;
            }
            return a2 + b2;
        };
    }

    protected static Double getMultiple(Double score, Double weight) {
        if (score == 0.0 || weight == 0.0) {
            return 0.0;
        }
        return score * weight;
    }

    protected long getResultSize() {
        Slice keyDest = this.params().get(0);
        if (this.base().exists(keyDest)) {
            this.base().deleteValue(keyDest);
        }
        this.startKeysIndex = 1;
        RMZSet mapDBObj = this.getFinishedZSet();
        if (!mapDBObj.isEmpty()) {
            this.base().putValue(keyDest, mapDBObj);
            this.lock.notifyAll();
        }
        return mapDBObj.size();
    }

    protected List<Slice> getResultArray() {
        this.startKeysIndex = 0;
        return this.getFinishedZSet().entries(false).stream().flatMap(e2 -> this.withScores ? Stream.of(e2.getValue(), Slice.create(String.valueOf(Math.round(e2.getScore())))) : Stream.of(e2.getValue())).map(Response::bulkString).collect(Collectors.toList());
    }
}

