/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.streams;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.streams.RMStream;
import com.github.fppt.jedismock.datastructures.streams.SequencedMap;
import com.github.fppt.jedismock.datastructures.streams.SequencedMapIterator;
import com.github.fppt.jedismock.datastructures.streams.StreamId;
import com.github.fppt.jedismock.exception.WrongStreamKeyException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.List;

public class Ranges
extends AbstractRedisOperation {
    protected int multiplier = 1;

    Ranges(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    protected StreamId preprocessExclusiveBorder(StreamId key2, boolean isStart) throws WrongStreamKeyException {
        if (isStart) {
            return key2.increment();
        }
        return key2.decrement();
    }

    protected StreamId preprocessKey(Slice key2, RMStream stream, boolean isStart) throws WrongStreamKeyException {
        StreamId id;
        String rawKey = key2.toString();
        if ("-".equals(rawKey)) {
            return stream.getStoredData().getHead();
        }
        if ("+".equals(rawKey)) {
            return stream.getStoredData().getTail();
        }
        boolean exclusive = false;
        if (rawKey.charAt(0) == '(') {
            exclusive = true;
            id = new StreamId(rawKey.substring(1));
        } else {
            id = new StreamId(key2);
        }
        if (exclusive) {
            id = this.preprocessExclusiveBorder(id, isStart);
        }
        return id;
    }

    protected Slice range() {
        StreamId end2;
        StreamId start2;
        RMStream stream = this.getStreamFromBaseOrCreateEmpty(this.params().get(0));
        SequencedMap<StreamId, SequencedMap<Slice, Slice>> map2 = stream.getStoredData();
        int count2 = map2.size();
        try {
            start2 = this.preprocessKey(this.params().get(1), stream, true);
            end2 = this.preprocessKey(this.params().get(2), stream, false);
        }
        catch (WrongStreamKeyException e2) {
            return Response.error(e2.getMessage());
        }
        if (this.params().size() > 3) {
            if (this.params().size() != 5) {
                return Response.error("ERR syntax error");
            }
            if (!"count".equalsIgnoreCase(this.params().get(3).toString())) {
                return Response.error("ERR syntax error");
            }
            try {
                count2 = Integer.parseInt(this.params().get(4).toString());
            }
            catch (NumberFormatException e3) {
                return Response.error("ERR value is not an integer or out of range");
            }
        }
        if (map2.size() == 0) {
            return Response.EMPTY_ARRAY;
        }
        if (this.multiplier == 1 ? start2.compareTo(map2.getTail()) > 0 : start2.compareTo(map2.getHead()) < 0) {
            return Response.EMPTY_ARRAY;
        }
        SequencedMapIterator<StreamId, SequencedMap<Slice, Slice>> it = this.multiplier == 1 ? map2.iterator(start2) : map2.reverseIterator(start2);
        ArrayList<Slice> output = new ArrayList<Slice>();
        int entriesAdded = 1;
        while (it.hasNext() && entriesAdded++ <= count2) {
            ArrayList<Slice> entrySlice = new ArrayList<Slice>();
            Object entry = it.next();
            if (this.multiplier * ((StreamId)entry.getKey()).compareTo(end2) > 0) break;
            ((SequencedMap)entry.getValue()).forEach((key2, value2) -> {
                entrySlice.add(Response.bulkString(key2));
                entrySlice.add(Response.bulkString(value2));
            });
            output.add(Response.array(Response.bulkString(((StreamId)entry.getKey()).toSlice()), Response.array(entrySlice)));
        }
        return Response.array(output);
    }

    @Override
    protected Slice response() {
        return null;
    }
}

