/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.streams;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.streams.RMStream;
import com.github.fppt.jedismock.datastructures.streams.SequencedMap;
import com.github.fppt.jedismock.datastructures.streams.StreamId;
import com.github.fppt.jedismock.exception.WrongStreamKeyException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.streams.XTrim;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="xadd")
public class XAdd
extends AbstractRedisOperation {
    public XAdd(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    void validate(StreamId key2) throws WrongStreamKeyException {
        if (key2.isZero()) {
            throw new WrongStreamKeyException("ERR The ID specified in XADD must be greater than 0-0");
        }
        StreamId lastId = this.getStreamFromBaseOrCreateEmpty(this.params().get(0)).getLastId();
        if (key2.compareTo(lastId) <= 0) {
            throw new WrongStreamKeyException("ERR The ID specified in XADD is equal or smaller than the target stream top item");
        }
    }

    @Override
    protected int minArgs() {
        return 4;
    }

    @Override
    protected Slice response() {
        StreamId nodeId;
        Slice key2 = this.params().get(0);
        RMStream stream = this.getStreamFromBaseOrCreateEmpty(key2);
        SequencedMap<StreamId, SequencedMap<Slice, Slice>> map2 = stream.getStoredData();
        int idInd = 1;
        if ("nomkstream".equalsIgnoreCase(this.params().get(1).toString())) {
            if (!this.base().exists(key2)) {
                return Response.NULL;
            }
            ++idInd;
        }
        String criterion = "";
        int thresholdPosition = idInd + 1;
        int limit = map2.size() + 1;
        String param = this.params().get(idInd).toString();
        if ("maxlen".equalsIgnoreCase(param) || "minid".equalsIgnoreCase(param)) {
            criterion = this.params().get(idInd++).toString();
            param = this.params().get(idInd++).toString();
            boolean approxTrim = "~".equals(param);
            if ("~".equals(param) || "=".equals(param)) {
                ++thresholdPosition;
                ++idInd;
            }
            if ("limit".equalsIgnoreCase(this.params().get(idInd).toString())) {
                try {
                    limit = Integer.parseInt(this.params().get(++idInd).toString());
                }
                catch (NumberFormatException e2) {
                    return Response.error("ERR value is not an integer or out of range");
                }
                if (!approxTrim) {
                    return Response.error("ERR syntax error, LIMIT cannot be used without the special ~ option");
                }
            }
        }
        int n = ++idInd;
        ++idInd;
        Slice id = this.params().get(n);
        try {
            nodeId = new StreamId(stream.replaceAsterisk(id));
            this.validate(nodeId);
        }
        catch (WrongStreamKeyException e3) {
            return Response.error(e3.getMessage());
        }
        SequencedMap<Slice, Slice> entryValues = new SequencedMap<Slice, Slice>();
        for (int i2 = idInd; i2 < this.params().size(); i2 += 2) {
            entryValues.append(this.params().get(i2), this.params().get(i2 + 1));
        }
        map2.append(nodeId, entryValues);
        stream.updateLastId(nodeId);
        this.base().putValue(key2, stream);
        switch (criterion.toUpperCase()) {
            case "MAXLEN": {
                try {
                    int threshold = Integer.parseInt(this.params().get(thresholdPosition).toString());
                    XTrim.trimLen(map2, threshold, limit);
                    break;
                }
                catch (NumberFormatException e4) {
                    return Response.error("ERR syntax error");
                }
            }
            case "MINID": {
                try {
                    StreamId threshold = new StreamId(this.params().get(thresholdPosition));
                    XTrim.trimID(map2, threshold, limit);
                    break;
                }
                catch (WrongStreamKeyException e5) {
                    return Response.error(e5.getMessage());
                }
            }
        }
        return Response.bulkString(nodeId.toSlice());
    }
}

