/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.streams;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.streams.SequencedMap;
import com.github.fppt.jedismock.datastructures.streams.StreamId;
import com.github.fppt.jedismock.exception.WrongStreamKeyException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.List;

@RedisCommand(value="xdel")
public class XDel
extends AbstractRedisOperation {
    XDel(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected int minArgs() {
        return 2;
    }

    @Override
    protected Slice response() {
        Slice key2 = this.params().get(0);
        SequencedMap<StreamId, SequencedMap<Slice, Slice>> map2 = this.getStreamFromBaseOrCreateEmpty(key2).getStoredData();
        ArrayList<StreamId> idsToBeDeleted = new ArrayList<StreamId>();
        try {
            for (int i2 = 1; i2 < this.params().size(); ++i2) {
                idsToBeDeleted.add(new StreamId(this.params().get(i2)));
            }
        }
        catch (WrongStreamKeyException e2) {
            return Response.error(e2.getMessage());
        }
        int removedCount = 0;
        for (StreamId id : idsToBeDeleted) {
            if (map2.remove(id) == null) continue;
            ++removedCount;
        }
        return Response.integer(removedCount);
    }
}

