/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.streams;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.streams.SequencedMap;
import com.github.fppt.jedismock.datastructures.streams.SequencedMapForwardIterator;
import com.github.fppt.jedismock.datastructures.streams.StreamId;
import com.github.fppt.jedismock.exception.WrongStreamKeyException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RedisCommand(value="xread")
public class XRead
extends AbstractRedisOperation {
    private final Object lock;
    private final boolean isInTransaction;

    public XRead(OperationExecutorState state, List<Slice> params) {
        super(state.base(), params);
        this.lock = state.lock();
        this.isInTransaction = state.isTransactionModeOn();
    }

    @Override
    protected int minArgs() {
        return 3;
    }

    @Override
    protected Slice response() {
        int count2;
        int streamInd = 0;
        long blockTimeNanosec = 0L;
        boolean isBlocking = false;
        if ("count".equalsIgnoreCase(this.params().get(streamInd).toString())) {
            int count3 = Integer.parseInt(this.params().get(++streamInd).toString());
            ++streamInd;
        } else {
            count2 = Integer.MAX_VALUE;
        }
        if ("block".equalsIgnoreCase(this.params().get(streamInd).toString())) {
            blockTimeNanosec = Long.parseLong(this.params().get(++streamInd).toString()) * 1000000L;
            isBlocking = true;
            if (blockTimeNanosec < 0L) {
                return Response.error("ERR timeout is negative");
            }
        }
        int n = ++streamInd;
        ++streamInd;
        if (!"streams".equalsIgnoreCase(this.params().get(n).toString())) {
            return Response.error("ERR syntax error");
        }
        if ((this.params().size() - streamInd) % 2 != 0) {
            return Response.error("ERR Unbalanced 'xread' list of streams: for each stream key an ID or '$' must be specified");
        }
        int streamsCount = (this.params().size() - streamInd) / 2;
        SequencedMap<Slice, StreamId> mapKeyToBeginEntryId = new SequencedMap<Slice, StreamId>();
        for (int i2 = 0; i2 < streamsCount; ++i2) {
            Slice key3 = this.params().get(streamInd + i2);
            Slice id2 = this.params().get(streamInd + streamsCount + i2);
            try {
                if (!this.base().exists(key3)) {
                    mapKeyToBeginEntryId.append(key3, "$".equalsIgnoreCase(id2.toString()) ? new StreamId(0L, 0L) : new StreamId(id2));
                    continue;
                }
                mapKeyToBeginEntryId.append(key3, "$".equalsIgnoreCase(id2.toString()) ? this.getStreamFromBaseOrCreateEmpty(key3).getStoredData().getTail() : new StreamId(id2));
                continue;
            }
            catch (WrongStreamKeyException e2) {
                return Response.error(e2.getMessage());
            }
        }
        ArrayList<Slice> output = new ArrayList<Slice>();
        long waitEnd = System.nanoTime() + blockTimeNanosec;
        if (isBlocking) {
            boolean updated = false;
            if (blockTimeNanosec > 0L) {
                try {
                    long waitTimeNanos;
                    while (!this.isInTransaction && !updated && (waitTimeNanos = waitEnd - System.nanoTime()) >= 0L) {
                        for (Map.Entry entry : mapKeyToBeginEntryId) {
                            if (!this.base().exists((Slice)entry.getKey()) || ((StreamId)entry.getValue()).compareTo(this.getStreamFromBaseOrCreateEmpty((Slice)entry.getKey()).getStoredData().getTail()) >= 0) continue;
                            updated = true;
                            break;
                        }
                        if (waitTimeNanos / 1000000L < 500L) {
                            this.lock.wait(waitTimeNanos / 1000000L, (int)waitTimeNanos % 1000000);
                            continue;
                        }
                        this.lock.wait(500L, 0);
                    }
                }
                catch (InterruptedException e3) {
                    Thread.currentThread().interrupt();
                    return Response.NULL;
                }
            }
            try {
                while (!this.isInTransaction && !updated) {
                    for (Map.Entry entry : mapKeyToBeginEntryId) {
                        if (!this.base().exists((Slice)entry.getKey()) || this.getStreamFromBaseOrCreateEmpty((Slice)entry.getKey()).getStoredData().getTail().compareTo((StreamId)entry.getValue()) <= 0) continue;
                        updated = true;
                        break;
                    }
                    this.lock.wait(500L, 0);
                }
            }
            catch (InterruptedException e4) {
                Thread.currentThread().interrupt();
                return Response.NULL;
            }
        }
        mapKeyToBeginEntryId.forEach((key2, id) -> {
            SequencedMap<StreamId, SequencedMap<Slice, Slice>> map2 = this.getStreamFromBaseOrCreateEmpty((Slice)key2).getStoredData();
            if (!this.base().exists((Slice)key2)) {
                return;
            }
            if (map2.getTail() == null || id.compareTo(map2.getTail()) >= 0) {
                return;
            }
            try {
                id = id.increment();
            }
            catch (WrongStreamKeyException e2) {
                return;
            }
            SequencedMapForwardIterator<StreamId, SequencedMap<Slice, Slice>> it = map2.iterator((StreamId)id);
            ArrayList<Slice> data2 = new ArrayList<Slice>();
            int addedEntries = 1;
            while (it.hasNext() && addedEntries++ <= count2) {
                Object entry = it.next();
                ArrayList<Slice> values2 = new ArrayList<Slice>();
                ((SequencedMap)entry.getValue()).forEach((k2, v) -> {
                    values2.add(Response.bulkString(k2));
                    values2.add(Response.bulkString(v));
                });
                data2.add(Response.array(Response.bulkString(((StreamId)entry.getKey()).toSlice()), Response.array(values2)));
            }
            output.add(Response.array(Response.bulkString(key2), Response.array(data2)));
        });
        return Response.array(output);
    }
}

