/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.strings;

import com.github.fppt.jedismock.datastructures.RMString;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.math.BigDecimal;
import java.util.List;

abstract class IncrOrDecrByFloat
extends AbstractRedisOperation {
    IncrOrDecrByFloat(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    private static BigDecimal toBigDecimal(String value2) {
        if (value2 != null) {
            if (value2.toLowerCase().endsWith("inf")) {
                throw new NumberFormatException("ERR increment would produce NaN or Infinity");
            }
            try {
                return new BigDecimal(value2);
            }
            catch (NumberFormatException e2) {
                NumberFormatException modified = new NumberFormatException("ERR value is not a valid float");
                modified.initCause(e2);
                throw modified;
            }
        }
        throw new NumberFormatException("ERR value is not a valid float");
    }

    @Override
    protected Slice response() {
        Slice key2 = this.params().get(0);
        BigDecimal numericValue = IncrOrDecrByFloat.toBigDecimal(this.params().get(1).toString());
        RMString foundValue = this.base().getRMString(key2);
        if (foundValue != null) {
            numericValue = numericValue.add(IncrOrDecrByFloat.toBigDecimal(foundValue.getStoredDataAsString()));
        }
        String data2 = String.valueOf(BigDecimal.valueOf(numericValue.intValue()).compareTo(numericValue) == 0 ? Integer.valueOf(numericValue.intValue()) : numericValue);
        RMString res = RMString.create(data2);
        this.base().putValue(key2, res);
        return Response.bulkString(res.getAsSlice());
    }
}

