/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.transactions;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RedisCommand(value="exec", transactional=false)
public class Exec
implements RedisOperation {
    private static final Logger LOG = LoggerFactory.getLogger(Exec.class);
    private final OperationExecutorState state;

    public Exec(OperationExecutorState state) {
        this.state = state;
    }

    @Override
    public Slice execute() {
        if (!this.state.isTransactionModeOn()) {
            return Response.error("ERR EXEC without MULTI");
        }
        if (this.state.getTransactionState() == OperationExecutorState.TransactionState.ERRORED) {
            this.state.transactionMode(false);
            this.state.tx().clear();
            return Response.error("EXECABORT Transaction discarded because of previous errors.");
        }
        try {
            this.state.checkWatchedKeysNotExpired();
            boolean validTransaction = this.state.isValid();
            this.state.unwatch();
            this.state.transactionMode(false);
            if (!validTransaction) {
                this.state.tx().clear();
                return Response.NULL;
            }
            List<Slice> results2 = this.state.tx().stream().map(RedisOperation::execute).collect(Collectors.toList());
            this.state.tx().clear();
            return Response.array(results2);
        }
        catch (Throwable t2) {
            LOG.error("ERROR during committing transaction", t2);
            return Response.NULL;
        }
    }
}

