/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.server;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.server.SliceParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response {
    public static final String LINE_SEPARATOR = "\r\n";
    public static final Slice OK = Slice.create("+OK\r\n");
    public static final Slice QUEUED = Slice.create("+QUEUED\r\n");
    public static final Slice NULL = Slice.create("$-1\r\n");
    public static final Slice SKIP = Slice.create("Skip this submission");
    public static final Slice EMPTY_ARRAY = Response.array(new Slice[0]);
    public static final Slice NULL_ARRAY = Slice.create("*-1\r\n");
    private static final Logger LOG = LoggerFactory.getLogger(Response.class);

    private Response() {
    }

    public static Slice bulkString(Slice slice) {
        if (slice == null) {
            return NULL;
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(String.format("$%d%s", slice.data().length, LINE_SEPARATOR).getBytes());
            bo.write(slice.data());
            bo.write(LINE_SEPARATOR.getBytes());
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
        return Slice.create(bo.toByteArray());
    }

    public static Slice error(String s2) {
        return Slice.create(String.format("-%s%s", s2, LINE_SEPARATOR));
    }

    public static Slice integer(long v) {
        return Slice.create(String.format(":%d%s", v, LINE_SEPARATOR));
    }

    public static Slice doubleValue(double v) {
        return Slice.create(String.format(":%.0f%s", v, LINE_SEPARATOR));
    }

    public static Slice array(Slice ... values2) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(String.format("*%d%s", values2.length, LINE_SEPARATOR).getBytes());
            for (Slice value2 : values2) {
                bo.write(value2.data());
            }
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
        return Slice.create(bo.toByteArray());
    }

    public static Slice array(List<Slice> values2) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(String.format("*%d%s", values2.size(), LINE_SEPARATOR).getBytes());
            for (Slice value2 : values2) {
                bo.write(value2.data());
            }
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
        return Slice.create(bo.toByteArray());
    }

    public static Slice publishedMessage(Slice channel2, Slice message) {
        Slice operation = SliceParser.consumeParameter("$7\r\nmessage\r\n".getBytes());
        ArrayList<Slice> slices = new ArrayList<Slice>();
        slices.add(Response.bulkString(operation));
        slices.add(Response.bulkString(channel2));
        slices.add(Response.bulkString(message));
        return Response.array(slices);
    }

    public static Slice publishedPMessage(Slice pattern2, Slice channel2, Slice message) {
        Slice operation = SliceParser.consumeParameter("$8\r\npmessage\r\n".getBytes());
        ArrayList<Slice> slices = new ArrayList<Slice>();
        slices.add(Response.bulkString(operation));
        slices.add(Response.bulkString(pattern2));
        slices.add(Response.bulkString(channel2));
        slices.add(Response.bulkString(message));
        return Response.array(slices);
    }

    public static Slice subscribedToChannel(List<Slice> channels) {
        Slice operation = SliceParser.consumeParameter("$9\r\nsubscribe\r\n".getBytes());
        ArrayList<Slice> slices = new ArrayList<Slice>();
        int i2 = 0;
        for (Slice channel2 : channels) {
            slices.add(Response.bulkString(operation));
            slices.add(Response.bulkString(channel2));
            slices.add(Response.integer(++i2));
        }
        return Response.array(slices);
    }

    public static Slice psubscribedToChannel(List<Slice> patterns2) {
        Slice operation = SliceParser.consumeParameter("$10\r\npsubscribe\r\n".getBytes());
        ArrayList<Slice> slices = new ArrayList<Slice>();
        int i2 = 0;
        for (Slice pattern2 : patterns2) {
            slices.add(Response.bulkString(operation));
            slices.add(Response.bulkString(pattern2));
            slices.add(Response.integer(++i2));
        }
        return Response.array(slices);
    }

    public static Slice unsubscribe(Slice channel2, int remainingSubscriptions) {
        Slice operation = SliceParser.consumeParameter("$11\r\nunsubscribe\r\n".getBytes());
        ArrayList<Slice> slices = new ArrayList<Slice>();
        slices.add(Response.bulkString(operation));
        slices.add(Response.bulkString(channel2));
        slices.add(Response.integer(remainingSubscriptions));
        return Response.array(slices);
    }

    public static Slice punsubscribe(Slice channel2, int remainingSubscriptions) {
        Slice operation = SliceParser.consumeParameter("$12\r\npunsubscribe\r\n".getBytes());
        ArrayList<Slice> slices = new ArrayList<Slice>();
        slices.add(Response.bulkString(operation));
        slices.add(Response.bulkString(channel2));
        slices.add(Response.integer(remainingSubscriptions));
        return Response.array(slices);
    }

    public static Slice clientResponse(String command2, Slice response2) {
        String stringResponse = response2.toString().replace("\n", "").replace("\r", "");
        if (!response2.equals(SKIP)) {
            LOG.debug("Received command [" + command2 + "] sending reply [" + stringResponse + "]");
        }
        return response2;
    }
}

