/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.storage;

import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.RMHash;
import com.github.fppt.jedismock.datastructures.Slice;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ExpiringKeyValueStorage {
    private final Supplier<Clock> clockSupplier;
    private final Map<Slice, RMDataStructure> values = new HashMap<Slice, RMDataStructure>();
    private final Map<Slice, Long> ttls = new HashMap<Slice, Long>();
    private final Consumer<Slice> keyChangeNotifier;

    public ExpiringKeyValueStorage(Supplier<Clock> clockSupplier, Consumer<Slice> keyChangeNotifier) {
        this.clockSupplier = Objects.requireNonNull(clockSupplier);
        this.keyChangeNotifier = Objects.requireNonNull(keyChangeNotifier);
    }

    public Map<Slice, RMDataStructure> values() {
        return this.values;
    }

    public Map<Slice, Long> ttls() {
        return this.ttls;
    }

    public void delete(Slice key2) {
        this.keyChangeNotifier.accept(key2);
        this.ttls().remove(key2);
        this.values().remove(key2);
    }

    public void delete(Slice key1, Slice key2) {
        this.keyChangeNotifier.accept(key1);
        Objects.requireNonNull(key2);
        if (!this.verifyKey(key1)) {
            return;
        }
        RMHash sortedSetByKey = this.getRMSortedSet(key1);
        Map<Slice, Slice> storedData = sortedSetByKey.getStoredData();
        if (!storedData.containsKey(key2)) {
            return;
        }
        storedData.remove(key2);
        if (storedData.isEmpty()) {
            this.values.remove(key1);
        }
        if (!this.values().containsKey(key1)) {
            this.ttls().remove(key1);
        }
    }

    public void clear() {
        for (Slice key2 : this.values().keySet()) {
            if (this.isKeyOutdated(key2)) continue;
            this.keyChangeNotifier.accept(key2);
        }
        this.values().clear();
        this.ttls().clear();
    }

    public RMDataStructure getValue(Slice key2) {
        if (!this.verifyKey(key2)) {
            return null;
        }
        return this.values().get(key2);
    }

    private boolean verifyKey(Slice key2) {
        Objects.requireNonNull(key2);
        if (!this.values().containsKey(key2)) {
            return false;
        }
        if (this.isKeyOutdated(key2)) {
            this.delete(key2);
            return false;
        }
        return true;
    }

    boolean isKeyOutdated(Slice key2) {
        Long deadline = this.ttls().get(key2);
        return deadline != null && deadline != -1L && deadline <= this.getMillis();
    }

    public Long getTTL(Slice key2) {
        Objects.requireNonNull(key2);
        Long deadline = this.ttls().get(key2);
        if (deadline == null) {
            return null;
        }
        if (deadline == -1L) {
            return deadline;
        }
        long now = this.getMillis();
        if (now < deadline) {
            return deadline - now;
        }
        this.delete(key2);
        return null;
    }

    public long setTTL(Slice key2, long ttl) {
        this.keyChangeNotifier.accept(key2);
        return this.setDeadline(key2, ttl + this.getMillis());
    }

    private long getMillis() {
        return this.clockSupplier.get().millis();
    }

    public void put(Slice key2, RMDataStructure value2, Long ttl) {
        this.keyChangeNotifier.accept(key2);
        this.values().put(key2, value2);
        this.configureTTL(key2, ttl);
    }

    public void put(Slice key2, Slice value2, Long ttl) {
        this.keyChangeNotifier.accept(key2);
        Objects.requireNonNull(key2);
        Objects.requireNonNull(value2);
        this.values().put(key2, value2.extract());
        this.configureTTL(key2, ttl);
    }

    public void put(Slice key1, Slice key2, Slice value2, Long ttl) {
        RMHash mapByKey;
        this.keyChangeNotifier.accept(key1);
        Objects.requireNonNull(key1);
        Objects.requireNonNull(key2);
        Objects.requireNonNull(value2);
        if (!this.values.containsKey(key1)) {
            mapByKey = new RMHash();
            this.values.put(key1, mapByKey);
        } else {
            mapByKey = this.getRMSortedSet(key1);
        }
        mapByKey.put(key2, value2);
        this.configureTTL(key1, ttl);
    }

    private RMHash getRMSortedSet(Slice key2) {
        RMDataStructure valueByKey = this.values.get(key2);
        if (!this.isSortedSetValue(valueByKey)) {
            valueByKey.raiseTypeCastException();
        }
        return (RMHash)valueByKey;
    }

    private void configureTTL(Slice key2, Long ttl) {
        if (ttl == null) {
            if (this.getTTL(key2) == null) {
                this.setDeadline(key2, -1L);
            }
        } else if (ttl != -1L) {
            this.setTTL(key2, ttl);
        } else {
            this.setDeadline(key2, -1L);
        }
    }

    public long setDeadline(Slice key2, long deadline) {
        Objects.requireNonNull(key2);
        if (this.values().containsKey(key2)) {
            Long oldValue = this.ttls().put(key2, deadline);
            return deadline < 0L && (oldValue == null || oldValue < 0L) ? 0L : 1L;
        }
        return 0L;
    }

    public boolean exists(Slice slice) {
        return this.verifyKey(slice);
    }

    private boolean isSortedSetValue(RMDataStructure value2) {
        return value2 instanceof RMHash;
    }

    public Slice type(Slice key2) {
        if (!this.verifyKey(key2)) {
            return Slice.create("none");
        }
        RMDataStructure valueByKey = this.getValue(key2);
        if (valueByKey == null) {
            return Slice.create("none");
        }
        return Slice.create(valueByKey.getTypeName());
    }
}

