/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.storage;

import com.github.fppt.jedismock.RedisClient;
import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMBitMap;
import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.RMHash;
import com.github.fppt.jedismock.datastructures.RMHyperLogLog;
import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.RMSet;
import com.github.fppt.jedismock.datastructures.RMString;
import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.streams.RMStream;
import com.github.fppt.jedismock.storage.ExpiringKeyValueStorage;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class RedisBase {
    private static final long PROTO_MAX_BULK_LEN = 0x20000000L;
    private final Supplier<Clock> clockSupplier;
    private final Map<Slice, Set<RedisClient>> subscribers = new HashMap<Slice, Set<RedisClient>>();
    private final Map<Slice, Set<RedisClient>> psubscribers = new HashMap<Slice, Set<RedisClient>>();
    private final Map<Slice, Set<OperationExecutorState>> watchedKeys = new HashMap<Slice, Set<OperationExecutorState>>();
    private final Map<String, String> cachedLuaScripts = new HashMap<String, String>();
    private final ExpiringKeyValueStorage keyValueStorage;

    public RedisBase(Supplier<Clock> clockSupplier) {
        this.clockSupplier = Objects.requireNonNull(clockSupplier);
        this.keyValueStorage = new ExpiringKeyValueStorage(clockSupplier, key2 -> this.watchedKeys.getOrDefault(key2, Collections.emptySet()).forEach(OperationExecutorState::watchedKeyIsAffected));
    }

    public Clock getClock() {
        return this.clockSupplier.get();
    }

    public Set<Slice> keys() {
        Iterator<Slice> slices = this.keyValueStorage.values().keySet().iterator();
        HashSet<Slice> result2 = new HashSet<Slice>();
        while (slices.hasNext()) {
            Slice key2 = slices.next();
            if (this.keyValueStorage.isKeyOutdated(key2)) {
                slices.remove();
                continue;
            }
            result2.add(key2);
        }
        return result2;
    }

    public RMDataStructure getValue(Slice key2) {
        return this.keyValueStorage.getValue(key2);
    }

    private <T extends RMDataStructure> T getStructure(Slice key2, Class<T> tClass) {
        RMDataStructure value2 = this.getValue(key2);
        if (value2 == null) {
            return null;
        }
        if (tClass.isInstance(value2)) {
            return (T)value2;
        }
        value2.raiseTypeCastException();
        return null;
    }

    public RMStream getStream(Slice key2) {
        return this.getStructure(key2, RMStream.class);
    }

    public RMSet getSet(Slice key2) {
        return this.getStructure(key2, RMSet.class);
    }

    public RMZSet getZSet(Slice key2) {
        return this.getStructure(key2, RMZSet.class);
    }

    public RMList getList(Slice key2) {
        return this.getStructure(key2, RMList.class);
    }

    public RMHash getHash(Slice key2) {
        return this.getStructure(key2, RMHash.class);
    }

    public RMHyperLogLog getHLL(Slice key2) {
        return this.getStructure(key2, RMHyperLogLog.class);
    }

    public RMString getRMString(Slice key2) {
        return this.getStructure(key2, RMString.class);
    }

    public RMBitMap getBitMap(Slice key2) {
        RMDataStructure value2 = this.getValue(key2);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof RMBitMap) {
            return (RMBitMap)value2;
        }
        if (value2 instanceof RMString) {
            return new RMBitMap(((RMString)value2).getStoredData());
        }
        value2.raiseTypeCastException();
        return null;
    }

    public Slice getSlice(Slice key2) {
        RMDataStructure value2 = this.getValue(key2);
        if (value2 == null) {
            return null;
        }
        return value2.getAsSlice();
    }

    public Slice getSlice(Slice key1, Slice key2) {
        RMHash value2 = this.getHash(key1);
        if (value2 == null) {
            return null;
        }
        Map<Slice, Slice> innerMap = value2.getStoredData();
        if (innerMap == null) {
            return null;
        }
        return innerMap.get(key2);
    }

    public Map<Slice, Slice> getFieldsAndValues(Slice hash) {
        RMHash hashTable = this.getHash(hash);
        if (hashTable == null) {
            return Collections.emptyMap();
        }
        return hashTable.getStoredData();
    }

    public Long getTTL(Slice key2) {
        return this.keyValueStorage.getTTL(key2);
    }

    public long setTTL(Slice key2, long ttl) {
        return this.keyValueStorage.setTTL(key2, ttl);
    }

    public long setDeadline(Slice key2, long deadline) {
        return this.keyValueStorage.setDeadline(key2, deadline);
    }

    public Long getDeadline(Slice key2) {
        return this.keyValueStorage.ttls().get(key2);
    }

    public void clear() {
        this.keyValueStorage.clear();
        this.subscribers.clear();
    }

    public void putSlice(Slice key2, Slice value2, Long ttl) {
        this.keyValueStorage.put(key2, value2, ttl);
    }

    public void putSlice(Slice key1, Slice key2, Slice value2, Long ttl) {
        this.keyValueStorage.put(key1, key2, value2, ttl);
    }

    public void putValueWithoutClearingTtl(Slice key2, RMDataStructure value2) {
        this.putValue(key2, value2, null);
    }

    public void putValue(Slice key2, RMDataStructure value2, Long ttl) {
        this.keyValueStorage.put(key2, value2, ttl);
    }

    public void putValue(Slice key2, RMDataStructure value2) {
        this.keyValueStorage.put(key2, value2, (Long)-1L);
    }

    public void deleteValue(Slice key2) {
        this.keyValueStorage.delete(key2);
    }

    public void deleteValue(Slice key1, Slice key2) {
        this.keyValueStorage.delete(key1, key2);
    }

    public void addSubscriber(Slice channel2, RedisClient client2) {
        HashSet<RedisClient> newClient = new HashSet<RedisClient>();
        newClient.add(client2);
        this.subscribers.merge(channel2, newClient, (currentSubscribers, newSubscribers) -> {
            currentSubscribers.addAll(newSubscribers);
            return currentSubscribers;
        });
    }

    public void subscribeByPattern(Slice pattern2, RedisClient client2) {
        HashSet<RedisClient> newClient = new HashSet<RedisClient>();
        newClient.add(client2);
        this.psubscribers.merge(pattern2, newClient, (currentSubscribers, newSubscribers) -> {
            currentSubscribers.addAll(newSubscribers);
            return currentSubscribers;
        });
    }

    public boolean removeSubscriber(Slice channel2, RedisClient client2) {
        return this.removeSubscriber(channel2, client2, this.subscribers);
    }

    public boolean removePSubscriber(Slice channel2, RedisClient client2) {
        return this.removeSubscriber(channel2, client2, this.psubscribers);
    }

    private boolean removeSubscriber(Slice channel2, RedisClient client2, Map<Slice, Set<RedisClient>> subscribers) {
        if (subscribers.containsKey(channel2)) {
            Set<RedisClient> redisClients = subscribers.get(channel2);
            redisClients.remove(client2);
            if (redisClients.isEmpty()) {
                subscribers.remove(channel2);
            }
            return true;
        }
        return false;
    }

    public Set<RedisClient> getSubscribers(Slice channel2) {
        HashSet<RedisClient> subs = new HashSet<RedisClient>(Collections.emptySet());
        if (this.subscribers.containsKey(channel2)) {
            subs.addAll((Collection<RedisClient>)this.subscribers.get(channel2));
        }
        return subs;
    }

    public Map<Slice, Set<RedisClient>> getPsubscribers(Slice channel2) {
        HashMap<Slice, Set<RedisClient>> matchingPatterns = new HashMap<Slice, Set<RedisClient>>();
        String channelStr = channel2.toString();
        for (Map.Entry<Slice, Set<RedisClient>> patternSubscribedClients : this.psubscribers.entrySet()) {
            Slice jedisPattern = patternSubscribedClients.getKey();
            String regexpPattern = RedisBase.getRegexpFromPattern(jedisPattern);
            if (!channelStr.matches(regexpPattern)) continue;
            matchingPatterns.put(jedisPattern, patternSubscribedClients.getValue());
        }
        return matchingPatterns;
    }

    private static String getRegexpFromPattern(Slice pattern2) {
        String patternStr = pattern2.toString();
        if (patternStr.isEmpty()) {
            return ".*";
        }
        return Utils.createRegexFromGlob(patternStr);
    }

    public int getNumpat() {
        return this.psubscribers.size();
    }

    public Set<Slice> getChannels() {
        return this.subscribers.keySet();
    }

    public List<Slice> getSubscriptions(RedisClient client2) {
        ArrayList<Slice> subscriptions = new ArrayList<Slice>();
        this.subscribers.forEach((channel2, subscribers) -> {
            if (subscribers.contains(client2)) {
                subscriptions.add((Slice)channel2);
            }
        });
        return subscriptions;
    }

    public List<Slice> getPSubscriptions(RedisClient client2) {
        ArrayList<Slice> subscriptions = new ArrayList<Slice>();
        this.psubscribers.forEach((channel2, subscribers) -> {
            if (subscribers.contains(client2)) {
                subscriptions.add((Slice)channel2);
            }
        });
        return subscriptions;
    }

    public boolean exists(Slice slice) {
        return this.keyValueStorage.exists(slice);
    }

    public Slice type(Slice slice) {
        return this.keyValueStorage.type(slice);
    }

    public void watch(OperationExecutorState state, Slice key2) {
        this.watchedKeys.computeIfAbsent(key2, k2 -> new HashSet()).add(state);
    }

    public void unwatchSingleKey(OperationExecutorState state, Slice key2) {
        Set<OperationExecutorState> states = this.watchedKeys.get(key2);
        if (states != null) {
            states.remove(state);
            if (states.isEmpty()) {
                this.watchedKeys.remove(key2);
            }
        }
    }

    public void markKeyModified(Slice key2) {
        ((Set)this.watchedKeys.getOrDefault(key2, new HashSet())).forEach(OperationExecutorState::watchedKeyIsAffected);
    }

    public long getProtoMaxBulkLen() {
        return 0x20000000L;
    }

    public String getCachedLuaScript(String sha1) {
        return this.cachedLuaScripts.get(sha1.toLowerCase());
    }

    public boolean cachedLuaScriptExists(String sha1) {
        return this.cachedLuaScripts.containsKey(sha1.toLowerCase());
    }

    public void flushCachedLuaScrips() {
        this.cachedLuaScripts.clear();
    }

    public String addCachedLuaScript(String sha1, String script) {
        return this.cachedLuaScripts.put(sha1, script);
    }
}

