/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.MapIteratorCache;
import java.util.Map;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
final class MapRetrievalCache<K, V>
extends MapIteratorCache<K, V> {
    @CheckForNull
    private volatile transient CacheEntry<K, V> cacheEntry1;
    @CheckForNull
    private volatile transient CacheEntry<K, V> cacheEntry2;

    MapRetrievalCache(Map<K, V> backingMap) {
        super(backingMap);
    }

    @Override
    @CheckForNull
    V get(Object key2) {
        Preconditions.checkNotNull(key2);
        V value2 = this.getIfCached(key2);
        if (value2 != null) {
            return value2;
        }
        value2 = this.getWithoutCaching(key2);
        if (value2 != null) {
            this.addToCache(key2, value2);
        }
        return value2;
    }

    @Override
    @CheckForNull
    V getIfCached(@CheckForNull Object key2) {
        Object value2 = super.getIfCached(key2);
        if (value2 != null) {
            return value2;
        }
        CacheEntry<K, V> entry = this.cacheEntry1;
        if (entry != null && entry.key == key2) {
            return entry.value;
        }
        entry = this.cacheEntry2;
        if (entry != null && entry.key == key2) {
            this.addToCache(entry);
            return entry.value;
        }
        return null;
    }

    @Override
    void clearCache() {
        super.clearCache();
        this.cacheEntry1 = null;
        this.cacheEntry2 = null;
    }

    private void addToCache(K key2, V value2) {
        this.addToCache(new CacheEntry<K, V>(key2, value2));
    }

    private void addToCache(CacheEntry<K, V> entry) {
        this.cacheEntry2 = this.cacheEntry1;
        this.cacheEntry1 = entry;
    }

    private static final class CacheEntry<K, V> {
        final K key;
        final V value;

        CacheEntry(K key2, V value2) {
            this.key = key2;
            this.value = value2;
        }
    }
}

