/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class CountingOutputStream
extends FilterOutputStream {
    private long count;

    public CountingOutputStream(OutputStream out2) {
        super(Preconditions.checkNotNull(out2));
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public void write(byte[] b2, int off, int len2) throws IOException {
        this.out.write(b2, off, len2);
        this.count += (long)len2;
    }

    @Override
    public void write(int b2) throws IOException {
        this.out.write(b2);
        ++this.count;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

