/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.errorprone.annotations.InlineMe;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.Strictness;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class JsonParser {
    @Deprecated
    public JsonParser() {
    }

    public static JsonElement parseString(String json2) throws JsonSyntaxException {
        return JsonParser.parseReader(new StringReader(json2));
    }

    public static JsonElement parseReader(Reader reader2) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonReader = new JsonReader(reader2);
            JsonElement element = JsonParser.parseReader(jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return element;
        }
        catch (MalformedJsonException | NumberFormatException e2) {
            throw new JsonSyntaxException(e2);
        }
        catch (IOException e3) {
            throw new JsonIOException(e3);
        }
    }

    public static JsonElement parseReader(JsonReader reader2) throws JsonIOException, JsonSyntaxException {
        Strictness strictness = reader2.getStrictness();
        if (strictness == Strictness.LEGACY_STRICT) {
            reader2.setStrictness(Strictness.LENIENT);
        }
        try {
            JsonElement jsonElement = Streams.parse(reader2);
            return jsonElement;
        }
        catch (OutOfMemoryError | StackOverflowError e2) {
            throw new JsonParseException("Failed parsing JSON source: " + reader2 + " to Json", e2);
        }
        finally {
            reader2.setStrictness(strictness);
        }
    }

    @Deprecated
    @InlineMe(replacement="JsonParser.parseString(json)", imports={"com.google.gson.JsonParser"})
    public JsonElement parse(String json2) throws JsonSyntaxException {
        return JsonParser.parseString(json2);
    }

    @Deprecated
    @InlineMe(replacement="JsonParser.parseReader(json)", imports={"com.google.gson.JsonParser"})
    public JsonElement parse(Reader json2) throws JsonIOException, JsonSyntaxException {
        return JsonParser.parseReader(json2);
    }

    @Deprecated
    @InlineMe(replacement="JsonParser.parseReader(json)", imports={"com.google.gson.JsonParser"})
    public JsonElement parse(JsonReader json2) throws JsonIOException, JsonSyntaxException {
        return JsonParser.parseReader(json2);
    }
}

