/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public abstract class TypeAdapter<T> {
    public abstract void write(JsonWriter var1, T var2) throws IOException;

    public final void toJson(Writer out2, T value2) throws IOException {
        JsonWriter writer = new JsonWriter(out2);
        this.write(writer, value2);
    }

    public final String toJson(T value2) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.toJson(stringWriter, value2);
        }
        catch (IOException e2) {
            throw new JsonIOException(e2);
        }
        return stringWriter.toString();
    }

    public final JsonElement toJsonTree(T value2) {
        try {
            JsonTreeWriter jsonWriter = new JsonTreeWriter();
            this.write(jsonWriter, value2);
            return jsonWriter.get();
        }
        catch (IOException e2) {
            throw new JsonIOException(e2);
        }
    }

    public abstract T read(JsonReader var1) throws IOException;

    public final T fromJson(Reader in) throws IOException {
        JsonReader reader2 = new JsonReader(in);
        return this.read(reader2);
    }

    public final T fromJson(String json2) throws IOException {
        return this.fromJson(new StringReader(json2));
    }

    public final T fromJsonTree(JsonElement jsonTree) {
        try {
            JsonTreeReader jsonReader = new JsonTreeReader(jsonTree);
            return this.read(jsonReader);
        }
        catch (IOException e2) {
            throw new JsonIOException(e2);
        }
    }

    public final TypeAdapter<T> nullSafe() {
        if (!(this instanceof NullSafeTypeAdapter)) {
            return new NullSafeTypeAdapter();
        }
        return this;
    }

    private final class NullSafeTypeAdapter
    extends TypeAdapter<T> {
        private NullSafeTypeAdapter() {
        }

        @Override
        public void write(JsonWriter out2, T value2) throws IOException {
            if (value2 == null) {
                out2.nullValue();
            } else {
                TypeAdapter.this.write(out2, value2);
            }
        }

        @Override
        public T read(JsonReader reader2) throws IOException {
            if (reader2.peek() == JsonToken.NULL) {
                reader2.nextNull();
                return null;
            }
            return TypeAdapter.this.read(reader2);
        }

        public String toString() {
            return "NullSafeTypeAdapter[" + TypeAdapter.this + "]";
        }
    }
}

