/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.MetadataManager;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberMatch;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonemetadata;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.internal.RegexCache;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PhoneNumberMatcher
implements Iterator<PhoneNumberMatch> {
    private static final Pattern PATTERN;
    private static final Pattern PUB_PAGES;
    private static final Pattern SLASH_SEPARATED_DATES;
    private static final Pattern TIME_STAMPS;
    private static final Pattern TIME_STAMPS_SUFFIX;
    private static final Pattern MATCHING_BRACKETS;
    private static final Pattern[] INNER_MATCHES;
    private static final Pattern LEAD_CLASS;
    private final PhoneNumberUtil phoneUtil;
    private final CharSequence text;
    private final String preferredRegion;
    private final PhoneNumberUtil.Leniency leniency;
    private long maxTries;
    private State state = State.NOT_READY;
    private PhoneNumberMatch lastMatch = null;
    private int searchIndex = 0;
    private final RegexCache regexCache = new RegexCache(32);

    private static String limit(int lower2, int upper2) {
        if (lower2 < 0 || upper2 <= 0 || upper2 < lower2) {
            throw new IllegalArgumentException();
        }
        return "{" + lower2 + "," + upper2 + "}";
    }

    PhoneNumberMatcher(PhoneNumberUtil util, CharSequence text, String country, PhoneNumberUtil.Leniency leniency, long maxTries) {
        if (util == null || leniency == null) {
            throw new NullPointerException();
        }
        if (maxTries < 0L) {
            throw new IllegalArgumentException();
        }
        this.phoneUtil = util;
        this.text = text != null ? text : "";
        this.preferredRegion = country;
        this.leniency = leniency;
        this.maxTries = maxTries;
    }

    private PhoneNumberMatch find(int index) {
        Matcher matcher = PATTERN.matcher(this.text);
        while (this.maxTries > 0L && matcher.find(index)) {
            int start2 = matcher.start();
            CharSequence candidate = this.text.subSequence(start2, matcher.end());
            PhoneNumberMatch match2 = this.extractMatch(candidate = PhoneNumberMatcher.trimAfterFirstMatch(PhoneNumberUtil.SECOND_NUMBER_START_PATTERN, candidate), start2);
            if (match2 != null) {
                return match2;
            }
            index = start2 + candidate.length();
            --this.maxTries;
        }
        return null;
    }

    private static CharSequence trimAfterFirstMatch(Pattern pattern2, CharSequence candidate) {
        Matcher trailingCharsMatcher = pattern2.matcher(candidate);
        if (trailingCharsMatcher.find()) {
            candidate = candidate.subSequence(0, trailingCharsMatcher.start());
        }
        return candidate;
    }

    static boolean isLatinLetter(char letter) {
        if (!Character.isLetter(letter) && Character.getType(letter) != 6) {
            return false;
        }
        Character.UnicodeBlock block2 = Character.UnicodeBlock.of(letter);
        return block2.equals(Character.UnicodeBlock.BASIC_LATIN) || block2.equals(Character.UnicodeBlock.LATIN_1_SUPPLEMENT) || block2.equals(Character.UnicodeBlock.LATIN_EXTENDED_A) || block2.equals(Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL) || block2.equals(Character.UnicodeBlock.LATIN_EXTENDED_B) || block2.equals(Character.UnicodeBlock.COMBINING_DIACRITICAL_MARKS);
    }

    private static boolean isInvalidPunctuationSymbol(char character) {
        return character == '%' || Character.getType(character) == 26;
    }

    private PhoneNumberMatch extractMatch(CharSequence candidate, int offset) {
        String followingText;
        if (SLASH_SEPARATED_DATES.matcher(candidate).find()) {
            return null;
        }
        if (TIME_STAMPS.matcher(candidate).find() && TIME_STAMPS_SUFFIX.matcher(followingText = this.text.toString().substring(offset + candidate.length())).lookingAt()) {
            return null;
        }
        PhoneNumberMatch match2 = this.parseAndVerify(candidate, offset);
        if (match2 != null) {
            return match2;
        }
        return this.extractInnerMatch(candidate, offset);
    }

    private PhoneNumberMatch extractInnerMatch(CharSequence candidate, int offset) {
        for (Pattern possibleInnerMatch : INNER_MATCHES) {
            Matcher groupMatcher = possibleInnerMatch.matcher(candidate);
            boolean isFirstMatch = true;
            while (groupMatcher.find() && this.maxTries > 0L) {
                PhoneNumberMatch match2;
                CharSequence group;
                if (isFirstMatch) {
                    group = PhoneNumberMatcher.trimAfterFirstMatch(PhoneNumberUtil.UNWANTED_END_CHAR_PATTERN, candidate.subSequence(0, groupMatcher.start()));
                    match2 = this.parseAndVerify(group, offset);
                    if (match2 != null) {
                        return match2;
                    }
                    --this.maxTries;
                    isFirstMatch = false;
                }
                if ((match2 = this.parseAndVerify(group = PhoneNumberMatcher.trimAfterFirstMatch(PhoneNumberUtil.UNWANTED_END_CHAR_PATTERN, groupMatcher.group(1)), offset + groupMatcher.start(1))) != null) {
                    return match2;
                }
                --this.maxTries;
            }
        }
        return null;
    }

    private PhoneNumberMatch parseAndVerify(CharSequence candidate, int offset) {
        try {
            Phonenumber.PhoneNumber number;
            if (!MATCHING_BRACKETS.matcher(candidate).matches() || PUB_PAGES.matcher(candidate).find()) {
                return null;
            }
            if (this.leniency.compareTo(PhoneNumberUtil.Leniency.VALID) >= 0) {
                char nextChar;
                char previousChar;
                if (offset > 0 && !LEAD_CLASS.matcher(candidate).lookingAt() && (PhoneNumberMatcher.isInvalidPunctuationSymbol(previousChar = this.text.charAt(offset - 1)) || PhoneNumberMatcher.isLatinLetter(previousChar))) {
                    return null;
                }
                int lastCharIndex = offset + candidate.length();
                if (lastCharIndex < this.text.length() && (PhoneNumberMatcher.isInvalidPunctuationSymbol(nextChar = this.text.charAt(lastCharIndex)) || PhoneNumberMatcher.isLatinLetter(nextChar))) {
                    return null;
                }
            }
            if (this.leniency.verify(number = this.phoneUtil.parseAndKeepRawInput(candidate, this.preferredRegion), candidate, this.phoneUtil, this)) {
                number.clearCountryCodeSource();
                number.clearRawInput();
                number.clearPreferredDomesticCarrierCode();
                return new PhoneNumberMatch(offset, candidate.toString(), number);
            }
        }
        catch (NumberParseException numberParseException) {
            // empty catch block
        }
        return null;
    }

    static boolean allNumberGroupsRemainGrouped(PhoneNumberUtil util, Phonenumber.PhoneNumber number, StringBuilder normalizedCandidate, String[] formattedNumberGroups) {
        int fromIndex = 0;
        if (number.getCountryCodeSource() != Phonenumber.PhoneNumber.CountryCodeSource.FROM_DEFAULT_COUNTRY) {
            String countryCode = Integer.toString(number.getCountryCode());
            fromIndex = normalizedCandidate.indexOf(countryCode) + countryCode.length();
        }
        for (int i2 = 0; i2 < formattedNumberGroups.length; ++i2) {
            String region;
            if ((fromIndex = normalizedCandidate.indexOf(formattedNumberGroups[i2], fromIndex)) < 0) {
                return false;
            }
            if (i2 != 0 || (fromIndex += formattedNumberGroups[i2].length()) >= normalizedCandidate.length() || util.getNddPrefixForRegion(region = util.getRegionCodeForCountryCode(number.getCountryCode()), true) == null || !Character.isDigit(normalizedCandidate.charAt(fromIndex))) continue;
            String nationalSignificantNumber = util.getNationalSignificantNumber(number);
            return normalizedCandidate.substring(fromIndex - formattedNumberGroups[i2].length()).startsWith(nationalSignificantNumber);
        }
        return normalizedCandidate.substring(fromIndex).contains(number.getExtension());
    }

    static boolean allNumberGroupsAreExactlyPresent(PhoneNumberUtil util, Phonenumber.PhoneNumber number, StringBuilder normalizedCandidate, String[] formattedNumberGroups) {
        int candidateNumberGroupIndex;
        String[] candidateGroups = PhoneNumberUtil.NON_DIGITS_PATTERN.split(normalizedCandidate.toString());
        int n = candidateNumberGroupIndex = number.hasExtension() ? candidateGroups.length - 2 : candidateGroups.length - 1;
        if (candidateGroups.length == 1 || candidateGroups[candidateNumberGroupIndex].contains(util.getNationalSignificantNumber(number))) {
            return true;
        }
        for (int formattedNumberGroupIndex = formattedNumberGroups.length - 1; formattedNumberGroupIndex > 0 && candidateNumberGroupIndex >= 0; --formattedNumberGroupIndex, --candidateNumberGroupIndex) {
            if (candidateGroups[candidateNumberGroupIndex].equals(formattedNumberGroups[formattedNumberGroupIndex])) continue;
            return false;
        }
        return candidateNumberGroupIndex >= 0 && candidateGroups[candidateNumberGroupIndex].endsWith(formattedNumberGroups[0]);
    }

    private static String[] getNationalNumberGroups(PhoneNumberUtil util, Phonenumber.PhoneNumber number) {
        String rfc3966Format = util.format(number, PhoneNumberUtil.PhoneNumberFormat.RFC3966);
        int endIndex = rfc3966Format.indexOf(59);
        if (endIndex < 0) {
            endIndex = rfc3966Format.length();
        }
        int startIndex = rfc3966Format.indexOf(45) + 1;
        return rfc3966Format.substring(startIndex, endIndex).split("-");
    }

    private static String[] getNationalNumberGroups(PhoneNumberUtil util, Phonenumber.PhoneNumber number, Phonemetadata.NumberFormat formattingPattern) {
        String nationalSignificantNumber = util.getNationalSignificantNumber(number);
        return util.formatNsnUsingPattern(nationalSignificantNumber, formattingPattern, PhoneNumberUtil.PhoneNumberFormat.RFC3966).split("-");
    }

    boolean checkNumberGroupingIsValid(Phonenumber.PhoneNumber number, CharSequence candidate, PhoneNumberUtil util, NumberGroupingChecker checker) {
        String[] formattedNumberGroups;
        StringBuilder normalizedCandidate = PhoneNumberUtil.normalizeDigits(candidate, true);
        if (checker.checkGroups(util, number, normalizedCandidate, formattedNumberGroups = PhoneNumberMatcher.getNationalNumberGroups(util, number))) {
            return true;
        }
        Phonemetadata.PhoneMetadata alternateFormats = MetadataManager.getAlternateFormatsForCountry(number.getCountryCode());
        String nationalSignificantNumber = util.getNationalSignificantNumber(number);
        if (alternateFormats != null) {
            for (Phonemetadata.NumberFormat alternateFormat : alternateFormats.numberFormats()) {
                Pattern pattern2;
                if (alternateFormat.leadingDigitsPatternSize() > 0 && !(pattern2 = this.regexCache.getPatternForRegex(alternateFormat.getLeadingDigitsPattern(0))).matcher(nationalSignificantNumber).lookingAt() || !checker.checkGroups(util, number, normalizedCandidate, formattedNumberGroups = PhoneNumberMatcher.getNationalNumberGroups(util, number, alternateFormat))) continue;
                return true;
            }
        }
        return false;
    }

    static boolean containsMoreThanOneSlashInNationalNumber(Phonenumber.PhoneNumber number, String candidate) {
        boolean candidateHasCountryCode;
        int firstSlashInBodyIndex = candidate.indexOf(47);
        if (firstSlashInBodyIndex < 0) {
            return false;
        }
        int secondSlashInBodyIndex = candidate.indexOf(47, firstSlashInBodyIndex + 1);
        if (secondSlashInBodyIndex < 0) {
            return false;
        }
        boolean bl = candidateHasCountryCode = number.getCountryCodeSource() == Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITH_PLUS_SIGN || number.getCountryCodeSource() == Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITHOUT_PLUS_SIGN;
        if (candidateHasCountryCode && PhoneNumberUtil.normalizeDigitsOnly(candidate.substring(0, firstSlashInBodyIndex)).equals(Integer.toString(number.getCountryCode()))) {
            return candidate.substring(secondSlashInBodyIndex + 1).contains("/");
        }
        return true;
    }

    static boolean containsOnlyValidXChars(Phonenumber.PhoneNumber number, String candidate, PhoneNumberUtil util) {
        for (int index = 0; index < candidate.length() - 1; ++index) {
            char charAtNextIndex;
            char charAtIndex = candidate.charAt(index);
            if (charAtIndex != 'x' && charAtIndex != 'X' || !((charAtNextIndex = candidate.charAt(index + 1)) == 'x' || charAtNextIndex == 'X' ? util.isNumberMatch(number, (CharSequence)candidate.substring(++index)) != PhoneNumberUtil.MatchType.NSN_MATCH : !PhoneNumberUtil.normalizeDigitsOnly(candidate.substring(index)).equals(number.getExtension()))) continue;
            return false;
        }
        return true;
    }

    static boolean isNationalPrefixPresentIfRequired(Phonenumber.PhoneNumber number, PhoneNumberUtil util) {
        if (number.getCountryCodeSource() != Phonenumber.PhoneNumber.CountryCodeSource.FROM_DEFAULT_COUNTRY) {
            return true;
        }
        String phoneNumberRegion = util.getRegionCodeForCountryCode(number.getCountryCode());
        Phonemetadata.PhoneMetadata metadata = util.getMetadataForRegion(phoneNumberRegion);
        if (metadata == null) {
            return true;
        }
        String nationalNumber = util.getNationalSignificantNumber(number);
        Phonemetadata.NumberFormat formatRule = util.chooseFormattingPatternForNumber(metadata.numberFormats(), nationalNumber);
        if (formatRule != null && formatRule.getNationalPrefixFormattingRule().length() > 0) {
            if (formatRule.getNationalPrefixOptionalWhenFormatting()) {
                return true;
            }
            if (PhoneNumberUtil.formattingRuleHasFirstGroupOnly(formatRule.getNationalPrefixFormattingRule())) {
                return true;
            }
            String rawInputCopy = PhoneNumberUtil.normalizeDigitsOnly(number.getRawInput());
            StringBuilder rawInput = new StringBuilder(rawInputCopy);
            return util.maybeStripNationalPrefixAndCarrierCode(rawInput, metadata, null);
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        if (this.state == State.NOT_READY) {
            this.lastMatch = this.find(this.searchIndex);
            if (this.lastMatch == null) {
                this.state = State.DONE;
            } else {
                this.searchIndex = this.lastMatch.end();
                this.state = State.READY;
            }
        }
        return this.state == State.READY;
    }

    @Override
    public PhoneNumberMatch next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        PhoneNumberMatch result2 = this.lastMatch;
        this.lastMatch = null;
        this.state = State.NOT_READY;
        return result2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static {
        PUB_PAGES = Pattern.compile("\\d{1,5}-+\\d{1,5}\\s{0,4}\\(\\d{1,4}");
        SLASH_SEPARATED_DATES = Pattern.compile("(?:(?:[0-3]?\\d/[01]?\\d)|(?:[01]?\\d/[0-3]?\\d))/(?:[12]\\d)?\\d{2}");
        TIME_STAMPS = Pattern.compile("[12]\\d{3}[-/]?[01]\\d[-/]?[0-3]\\d +[0-2]\\d$");
        TIME_STAMPS_SUFFIX = Pattern.compile(":[0-5]\\d");
        INNER_MATCHES = new Pattern[]{Pattern.compile("/+(.*)"), Pattern.compile("(\\([^(]*)"), Pattern.compile("(?:\\p{Z}-|-\\p{Z})\\p{Z}*(.+)"), Pattern.compile("[\u2012-\u2015\uff0d]\\p{Z}*(.+)"), Pattern.compile("\\.+\\p{Z}*([^.]+)"), Pattern.compile("\\p{Z}+(\\P{Z}+)")};
        String openingParens = "(\\[\uff08\uff3b";
        String closingParens = ")\\]\uff09\uff3d";
        String nonParens = "[^" + openingParens + closingParens + "]";
        String bracketPairLimit = PhoneNumberMatcher.limit(0, 3);
        MATCHING_BRACKETS = Pattern.compile("(?:[" + openingParens + "])?(?:" + nonParens + "+[" + closingParens + "])?" + nonParens + "+(?:[" + openingParens + "]" + nonParens + "+[" + closingParens + "])" + bracketPairLimit + nonParens + "*");
        String leadLimit = PhoneNumberMatcher.limit(0, 2);
        String punctuationLimit = PhoneNumberMatcher.limit(0, 4);
        int digitBlockLimit = 20;
        String blockLimit = PhoneNumberMatcher.limit(0, digitBlockLimit);
        String punctuation = "[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u00ad\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e]" + punctuationLimit;
        String digitSequence = "\\p{Nd}" + PhoneNumberMatcher.limit(1, digitBlockLimit);
        String leadClassChars = openingParens + "+\uff0b";
        String leadClass = "[" + leadClassChars + "]";
        LEAD_CLASS = Pattern.compile(leadClass);
        PATTERN = Pattern.compile("(?:" + leadClass + punctuation + ")" + leadLimit + digitSequence + "(?:" + punctuation + digitSequence + ")" + blockLimit + "(?:" + PhoneNumberUtil.EXTN_PATTERNS_FOR_MATCHING + ")?", 66);
    }

    static interface NumberGroupingChecker {
        public boolean checkGroups(PhoneNumberUtil var1, Phonenumber.PhoneNumber var2, StringBuilder var3, String[] var4);
    }

    private static enum State {
        NOT_READY,
        READY,
        DONE;

    }
}

