/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class RegexCache {
    private LRUCache<String, Pattern> cache;

    public RegexCache(int size2) {
        this.cache = new LRUCache(size2);
    }

    public Pattern getPatternForRegex(String regex) {
        Pattern pattern2 = this.cache.get(regex);
        if (pattern2 == null) {
            pattern2 = Pattern.compile(regex);
            this.cache.put(regex, pattern2);
        }
        return pattern2;
    }

    boolean containsRegex(String regex) {
        return this.cache.containsKey(regex);
    }

    private static class LRUCache<K, V> {
        private LinkedHashMap<K, V> map;
        private int size;

        public LRUCache(int size2) {
            this.size = size2;
            this.map = new LinkedHashMap<K, V>(size2 * 4 / 3 + 1, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                    return this.size() > LRUCache.this.size;
                }
            };
        }

        public synchronized V get(K key2) {
            return this.map.get(key2);
        }

        public synchronized void put(K key2, V value2) {
            this.map.put(key2, value2);
        }

        public synchronized boolean containsKey(K key2) {
            return this.map.containsKey(key2);
        }
    }
}

