/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BufferedXORIterator;
import com.googlecode.javaewah.CloneableIterator;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.IteratorAggregation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

class BufferedORIterator
implements CloneableIterator<EWAHIterator> {
    final EWAHCompressedBitmap buffer = new EWAHCompressedBitmap();
    final long[] hardBitmap;
    final LinkedList<IteratingRLW> ll;

    BufferedORIterator(LinkedList<IteratingRLW> basell, int bufSize) {
        this.ll = basell;
        this.hardBitmap = new long[bufSize];
    }

    public BufferedXORIterator clone() throws CloneNotSupportedException {
        BufferedXORIterator answer = (BufferedXORIterator)super.clone();
        answer.buffer = this.buffer.clone();
        answer.hardbitmap = (long[])this.hardBitmap.clone();
        answer.ll = (LinkedList)this.ll.clone();
        return answer;
    }

    @Override
    public boolean hasNext() {
        return !this.ll.isEmpty();
    }

    @Override
    public EWAHIterator next() {
        this.buffer.clear();
        long effective = 0L;
        Iterator i2 = this.ll.iterator();
        while (i2.hasNext()) {
            IteratingRLW rlw = (IteratingRLW)i2.next();
            if (rlw.size() > 0L) {
                int eff = IteratorAggregation.inplaceor(this.hardBitmap, rlw);
                if ((long)eff <= effective) continue;
                effective = eff;
                continue;
            }
            i2.remove();
        }
        int k2 = 0;
        while ((long)k2 < effective) {
            this.buffer.addWord(this.hardBitmap[k2]);
            ++k2;
        }
        Arrays.fill(this.hardBitmap, 0L);
        return this.buffer.getEWAHIterator();
    }
}

