/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitCounter;
import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.Buffer;
import com.googlecode.javaewah.ChunkIterator;
import com.googlecode.javaewah.ChunkIteratorImpl;
import com.googlecode.javaewah.ClearIntIterator;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.FastAggregation;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.IntIteratorImpl;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah.LongArray;
import com.googlecode.javaewah.LongBufferWrapper;
import com.googlecode.javaewah.NonEmptyVirtualStorage;
import com.googlecode.javaewah.ReverseEWAHIterator;
import com.googlecode.javaewah.ReverseIntIterator;
import com.googlecode.javaewah.RunningLengthWord;
import com.googlecode.javaewah.symmetric.RunningBitmapMerge;
import com.googlecode.javaewah.symmetric.ThresholdFuncBitmap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class EWAHCompressedBitmap
implements Cloneable,
Externalizable,
Iterable<Integer>,
BitmapStorage,
LogicalElement<EWAHCompressedBitmap> {
    final Buffer buffer;
    private RunningLengthWord rlw = null;
    private int sizeInBits = 0;
    public static final boolean ADJUST_CONTAINER_SIZE_WHEN_AGGREGATING = true;
    public static final int WORD_IN_BITS = 64;
    static final long serialVersionUID = 1L;

    public EWAHCompressedBitmap() {
        this(new LongArray());
    }

    public EWAHCompressedBitmap(int bufferSize) {
        this(new LongArray(bufferSize));
    }

    public EWAHCompressedBitmap(ByteBuffer buffer) {
        IntBuffer ib = buffer.asIntBuffer();
        this.sizeInBits = ib.get(0);
        int sizeInWords = ib.get(1);
        int rlwposition = ib.get(2 + sizeInWords * 2);
        LongBuffer lb = buffer.asLongBuffer();
        lb.position(1);
        this.buffer = new LongBufferWrapper(lb.slice(), sizeInWords);
        this.rlw = new RunningLengthWord(this.buffer, rlwposition);
    }

    public EWAHCompressedBitmap(LongBuffer buffer) {
        this(new LongBufferWrapper(buffer));
    }

    private EWAHCompressedBitmap(Buffer buffer) {
        this.buffer = buffer;
        this.rlw = new RunningLengthWord(this.buffer, 0);
    }

    @Deprecated
    public void add(long newData) {
        this.addWord(newData);
    }

    @Deprecated
    public void add(long newData, int bitsThatMatter) {
        this.addWord(newData, bitsThatMatter);
    }

    @Override
    public void addWord(long newData) {
        this.addWord(newData, 64);
    }

    public void addWord(long newData, int bitsThatMatter) {
        this.sizeInBits += bitsThatMatter;
        if (newData == 0L) {
            this.insertEmptyWord(false);
        } else if (newData == -1L) {
            this.insertEmptyWord(true);
        } else {
            this.insertLiteralWord(newData);
        }
    }

    private void insertEmptyWord(boolean v) {
        boolean noLiteralWords = this.rlw.getNumberOfLiteralWords() == 0;
        long runningLength = this.rlw.getRunningLength();
        if (noLiteralWords && runningLength == 0L) {
            this.rlw.setRunningBit(v);
        }
        if (noLiteralWords && this.rlw.getRunningBit() == v && runningLength < 0xFFFFFFFFL) {
            this.rlw.setRunningLength(runningLength + 1L);
            return;
        }
        this.buffer.push_back(0L);
        this.rlw.position = this.buffer.sizeInWords() - 1;
        this.rlw.setRunningBit(v);
        this.rlw.setRunningLength(1L);
    }

    @Override
    public void addLiteralWord(long newData) {
        this.sizeInBits += 64;
        this.insertLiteralWord(newData);
    }

    private void insertLiteralWord(long newData) {
        int numberSoFar = this.rlw.getNumberOfLiteralWords();
        if (numberSoFar >= Integer.MAX_VALUE) {
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            this.rlw.setNumberOfLiteralWords(1L);
            this.buffer.push_back(newData);
        } else {
            this.rlw.setNumberOfLiteralWords(numberSoFar + 1);
            this.buffer.push_back(newData);
        }
    }

    @Override
    public void addStreamOfLiteralWords(Buffer buffer, int start2, int number) {
        int leftOverNumber = number;
        while (leftOverNumber > 0) {
            int numberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
            int whatWeCanAdd = leftOverNumber < Integer.MAX_VALUE - numberOfLiteralWords ? leftOverNumber : Integer.MAX_VALUE - numberOfLiteralWords;
            this.rlw.setNumberOfLiteralWords(numberOfLiteralWords + whatWeCanAdd);
            this.buffer.push_back(buffer, start2, whatWeCanAdd);
            this.sizeInBits += whatWeCanAdd * 64;
            if ((leftOverNumber -= whatWeCanAdd) <= 0) continue;
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, long number) {
        if (number == 0L) {
            return;
        }
        this.sizeInBits += (int)(number * 64L);
        this.fastaddStreamOfEmptyWords(v, number);
    }

    @Override
    public void addStreamOfNegatedLiteralWords(Buffer buffer, int start2, int number) {
        int leftOverNumber = number;
        while (leftOverNumber > 0) {
            int numberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
            int whatWeCanAdd = leftOverNumber < Integer.MAX_VALUE - numberOfLiteralWords ? leftOverNumber : Integer.MAX_VALUE - numberOfLiteralWords;
            this.rlw.setNumberOfLiteralWords(numberOfLiteralWords + whatWeCanAdd);
            this.buffer.negative_push_back(buffer, start2, whatWeCanAdd);
            this.sizeInBits += whatWeCanAdd * 64;
            if ((leftOverNumber -= whatWeCanAdd) <= 0) continue;
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
        }
    }

    @Override
    public EWAHCompressedBitmap and(EWAHCompressedBitmap a2) {
        int size2 = this.buffer.sizeInWords() > a2.buffer.sizeInWords() ? this.buffer.sizeInWords() : a2.buffer.sizeInWords();
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size2);
        this.andToContainer(a2, container);
        return container;
    }

    public void andToContainer(EWAHCompressedBitmap a2, BitmapStorage container) {
        container.clear();
        EWAHIterator i2 = a2.getEWAHIterator();
        EWAHIterator j2 = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i2);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j2);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else {
                    long index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k2 = 0; k2 < nbre_literal; ++k2) {
                container.addWord(rlwi.getLiteralWordAt(k2) & rlwj.getLiteralWordAt(k2));
            }
            rlwi.discardLiteralWords(nbre_literal);
            rlwj.discardLiteralWords(nbre_literal);
        }
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a2.sizeInBits()));
    }

    public int andCardinality(EWAHCompressedBitmap a2) {
        BitCounter counter2 = new BitCounter();
        this.andToContainer(a2, counter2);
        return counter2.getCount();
    }

    @Override
    public EWAHCompressedBitmap andNot(EWAHCompressedBitmap a2) {
        int size2 = this.buffer.sizeInWords() > a2.buffer.sizeInWords() ? this.buffer.sizeInWords() : a2.buffer.sizeInWords();
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size2);
        this.andNotToContainer(a2, container);
        return container;
    }

    public void andNotToContainer(EWAHCompressedBitmap a2, BitmapStorage container) {
        IteratingBufferedRunningLengthWord remaining;
        container.clear();
        EWAHIterator i2 = this.getEWAHIterator();
        EWAHIterator j2 = a2.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i2);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j2);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                long index;
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit() && i_is_prey || !predator.getRunningBit() && !i_is_prey) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else if (i_is_prey) {
                    index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                } else {
                    index = prey.dischargeNegated(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(true, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k2 = 0; k2 < nbre_literal; ++k2) {
                container.addWord(rlwi.getLiteralWordAt(k2) & (rlwj.getLiteralWordAt(k2) ^ 0xFFFFFFFFFFFFFFFFL));
            }
            rlwi.discardLiteralWords(nbre_literal);
            rlwj.discardLiteralWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = remaining = i_remains ? rlwi : rlwj;
        if (i_remains) {
            remaining.discharge(container);
        }
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a2.sizeInBits()));
    }

    public int andNotCardinality(EWAHCompressedBitmap a2) {
        BitCounter counter2 = new BitCounter();
        this.andNotToContainer(a2, counter2);
        return counter2.getCount();
    }

    public int cardinality() {
        int counter2 = 0;
        EWAHIterator i2 = this.getEWAHIterator();
        while (i2.hasNext()) {
            RunningLengthWord localrlw = i2.next();
            if (localrlw.getRunningBit()) {
                counter2 += (int)(64L * localrlw.getRunningLength());
            }
            int numberOfLiteralWords = localrlw.getNumberOfLiteralWords();
            int literalWords = i2.literalWords();
            for (int j2 = 0; j2 < numberOfLiteralWords; ++j2) {
                counter2 += Long.bitCount(i2.buffer().getWord(literalWords + j2));
            }
        }
        return counter2;
    }

    @Override
    public void clear() {
        this.sizeInBits = 0;
        this.buffer.clear();
        this.rlw.position = 0;
    }

    public EWAHCompressedBitmap clone() throws CloneNotSupportedException {
        EWAHCompressedBitmap clone = new EWAHCompressedBitmap(this.buffer.clone());
        clone.sizeInBits = this.sizeInBits;
        clone.rlw = new RunningLengthWord(clone.buffer, this.rlw.position);
        return clone;
    }

    public void serialize(DataOutput out2) throws IOException {
        out2.writeInt(this.sizeInBits);
        int siw = this.buffer.sizeInWords();
        out2.writeInt(siw);
        for (int i2 = 0; i2 < siw; ++i2) {
            out2.writeLong(this.buffer.getWord(i2));
        }
        out2.writeInt(this.rlw.position);
    }

    public void deserialize(DataInput in) throws IOException {
        this.sizeInBits = in.readInt();
        int sizeInWords = in.readInt();
        this.buffer.clear();
        this.buffer.removeLastWord();
        this.buffer.ensureCapacity(sizeInWords);
        for (int i2 = 0; i2 < sizeInWords; ++i2) {
            this.buffer.push_back(in.readLong());
        }
        this.rlw = new RunningLengthWord(this.buffer, in.readInt());
    }

    public boolean equals(Object o) {
        if (o instanceof EWAHCompressedBitmap) {
            try {
                this.xorToContainer((EWAHCompressedBitmap)o, new NonEmptyVirtualStorage());
                return true;
            }
            catch (NonEmptyVirtualStorage.NonEmptyException e2) {
                return false;
            }
        }
        return false;
    }

    private void fastaddStreamOfEmptyWords(boolean v, long number) {
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0L) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
        }
        long runLen = this.rlw.getRunningLength();
        long whatWeCanAdd = number < 0xFFFFFFFFL - runLen ? number : 0xFFFFFFFFL - runLen;
        this.rlw.setRunningLength(runLen + whatWeCanAdd);
        number -= whatWeCanAdd;
        while (number >= 0xFFFFFFFFL) {
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
            this.rlw.setRunningLength(0xFFFFFFFFL);
            number -= 0xFFFFFFFFL;
        }
        if (number > 0L) {
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
            this.rlw.setRunningLength(number);
        }
    }

    public EWAHIterator getEWAHIterator() {
        return new EWAHIterator(this.buffer);
    }

    private ReverseEWAHIterator getReverseEWAHIterator() {
        return new ReverseEWAHIterator(this.buffer);
    }

    public IteratingRLW getIteratingRLW() {
        return new IteratingBufferedRunningLengthWord(this);
    }

    @Deprecated
    public List<Integer> getPositions() {
        return this.toList();
    }

    public List<Integer> toList() {
        ArrayList<Integer> v = new ArrayList<Integer>();
        EWAHIterator i2 = this.getEWAHIterator();
        int pos = 0;
        while (i2.hasNext()) {
            RunningLengthWord localrlw = i2.next();
            if (localrlw.getRunningBit()) {
                long N2 = localrlw.getRunningLength();
                for (long j2 = 0L; j2 < N2; ++j2) {
                    for (int c2 = 0; c2 < 64; ++c2) {
                        v.add(pos++);
                    }
                }
            } else {
                pos += (int)(64L * localrlw.getRunningLength());
            }
            int nlw = localrlw.getNumberOfLiteralWords();
            for (int j3 = 0; j3 < nlw; ++j3) {
                long T;
                for (long data2 = i2.buffer().getWord(i2.literalWords() + j3); data2 != 0L; data2 ^= T) {
                    T = data2 & -data2;
                    v.add(Long.bitCount(T - 1L) + pos);
                }
                pos += 64;
            }
        }
        while (v.size() > 0 && v.get(v.size() - 1) >= this.sizeInBits) {
            v.remove(v.size() - 1);
        }
        return v;
    }

    public int hashCode() {
        int karprabin = 0;
        int B = -1640531535;
        EWAHIterator i2 = this.getEWAHIterator();
        while (i2.hasNext()) {
            i2.next();
            if (i2.rlw.getRunningBit()) {
                long rl = i2.rlw.getRunningLength();
                karprabin += (int)(-1640531535L * (rl & 0xFFFFFFFFFFFFFFFFL));
                karprabin += (int)(-1640531535L * (rl >>> 32 & 0xFFFFFFFFFFFFFFFFL));
            }
            int nlw = i2.rlw.getNumberOfLiteralWords();
            int lw = i2.literalWords();
            for (int k2 = 0; k2 < nlw; ++k2) {
                long W = this.buffer.getWord(lw + k2);
                karprabin = (int)((long)karprabin + -1640531535L * (W & 0xFFFFFFFFFFFFFFFFL));
                karprabin = (int)((long)karprabin + -1640531535L * (W >>> 32 & 0xFFFFFFFFFFFFFFFFL));
            }
        }
        return karprabin;
    }

    public boolean intersects(EWAHCompressedBitmap a2) {
        NonEmptyVirtualStorage nevs = new NonEmptyVirtualStorage();
        try {
            this.andToContainer(a2, nevs);
        }
        catch (NonEmptyVirtualStorage.NonEmptyException nee) {
            return true;
        }
        return false;
    }

    public IntIterator intIterator() {
        return new IntIteratorImpl(this.getEWAHIterator());
    }

    public IntIterator reverseIntIterator() {
        return new ReverseIntIterator(this.getReverseEWAHIterator(), this.sizeInBits);
    }

    public boolean isEmpty() {
        return this.getFirstSetBit() < 0;
    }

    public IntIterator clearIntIterator() {
        return new ClearIntIterator(this.getEWAHIterator(), this.sizeInBits);
    }

    public ChunkIterator chunkIterator() {
        return new ChunkIteratorImpl(this.getEWAHIterator(), this.sizeInBits);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = EWAHCompressedBitmap.this.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public Integer next() {
                return this.under.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("bitsets do not support remove");
            }
        };
    }

    @Override
    public void not() {
        RunningLengthWord rlw1;
        EWAHIterator i2 = this.getEWAHIterator();
        if (!i2.hasNext()) {
            return;
        }
        do {
            rlw1.setRunningBit(!(rlw1 = i2.next()).getRunningBit());
            int nlw = rlw1.getNumberOfLiteralWords();
            for (int j2 = 0; j2 < nlw; ++j2) {
                int position = i2.literalWords() + j2;
                i2.buffer().negateWord(position);
            }
        } while (i2.hasNext());
        int usedBitsInLast = this.sizeInBits % 64;
        if (usedBitsInLast == 0) {
            return;
        }
        if (rlw1.getNumberOfLiteralWords() == 0) {
            if (rlw1.getRunningLength() > 0L && rlw1.getRunningBit()) {
                if (rlw1.getRunningLength() == 1L && rlw1.position > 0) {
                    EWAHIterator j3 = this.getEWAHIterator();
                    int newrlwpos = this.rlw.position;
                    while (j3.hasNext()) {
                        RunningLengthWord r = j3.next();
                        if (r.position >= rlw1.position) break;
                        newrlwpos = r.position;
                    }
                    this.rlw.position = newrlwpos;
                    this.buffer.removeLastWord();
                } else {
                    rlw1.setRunningLength(rlw1.getRunningLength() - 1L);
                }
                this.insertLiteralWord(-1L >>> 64 - usedBitsInLast);
            }
            return;
        }
        i2.buffer().andWord(i2.literalWords() + rlw1.getNumberOfLiteralWords() - 1, -1L >>> 64 - usedBitsInLast);
    }

    @Override
    public EWAHCompressedBitmap or(EWAHCompressedBitmap a2) {
        int size2 = this.buffer.sizeInWords() + a2.buffer.sizeInWords();
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size2);
        this.orToContainer(a2, container);
        return container;
    }

    public void orToContainer(EWAHCompressedBitmap a2, BitmapStorage container) {
        container.clear();
        EWAHIterator i2 = a2.getEWAHIterator();
        EWAHIterator j2 = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i2);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j2);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(true, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else {
                    long index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k2 = 0; k2 < nbre_literal; ++k2) {
                container.addWord(rlwi.getLiteralWordAt(k2) | rlwj.getLiteralWordAt(k2));
            }
            rlwi.discardLiteralWords(nbre_literal);
            rlwj.discardLiteralWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a2.sizeInBits()));
    }

    public int orCardinality(EWAHCompressedBitmap a2) {
        BitCounter counter2 = new BitCounter();
        this.orToContainer(a2, counter2);
        return counter2.getCount();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    @Override
    public void writeExternal(ObjectOutput out2) throws IOException {
        this.serialize(out2);
    }

    public int serializedSizeInBytes() {
        return this.sizeInBytes() + 12;
    }

    public boolean get(int i2) {
        if (i2 < 0 || i2 >= this.sizeInBits) {
            return false;
        }
        IteratingRLW j2 = this.getIteratingRLW();
        int wordi = i2 / 64;
        for (int wordChecked = 0; wordChecked <= wordi; wordChecked += j2.getNumberOfLiteralWords()) {
            if (wordi < (wordChecked += (int)j2.getRunningLength())) {
                return j2.getRunningBit();
            }
            if (wordi < wordChecked + j2.getNumberOfLiteralWords()) {
                long w = j2.getLiteralWordAt(wordi - wordChecked);
                return (w & 1L << i2) != 0L;
            }
            j2.next();
        }
        return false;
    }

    public int getFirstSetBit() {
        int nword = 0;
        int siw = this.buffer.sizeInWords();
        for (int pos = 0; pos < siw; ++pos) {
            long rl = RunningLengthWord.getRunningLength(this.buffer, pos);
            boolean rb = RunningLengthWord.getRunningBit(this.buffer, pos);
            if (rl > 0L && rb) {
                return nword * 64;
            }
            nword += (int)rl;
            long lw = RunningLengthWord.getNumberOfLiteralWords(this.buffer, pos);
            int p = pos + 1;
            while ((long)p <= (long)pos + lw) {
                long word = this.buffer.getWord(p);
                if (word != 0L) {
                    long T = word & -word;
                    return nword * 64 + Long.bitCount(T - 1L);
                }
                ++nword;
                ++p;
            }
        }
        return -1;
    }

    public boolean clear(int i2) {
        return this.set(i2, false);
    }

    public boolean set(int i2) {
        return this.set(i2, true);
    }

    private boolean set(int i2, boolean value2) {
        if (i2 > 0x7FFFFFBF || i2 < 0) {
            throw new IndexOutOfBoundsException("Position should be between 0 and 2147483583");
        }
        if (i2 < this.sizeInBits) {
            this.locateAndSet(i2, value2);
        } else {
            this.extendAndSet(i2, value2);
        }
        return true;
    }

    private void extendAndSet(int i2, boolean value2) {
        int dist = this.distanceInWords(i2);
        this.sizeInBits = i2 + 1;
        if (value2) {
            if (dist > 0) {
                if (this.rlw.getNumberOfLiteralWords() > 0 && this.buffer.getLastWord() == 0L) {
                    this.buffer.removeLastWord();
                    this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                    this.insertEmptyWord(false);
                }
                if (dist > 1) {
                    this.fastaddStreamOfEmptyWords(false, dist - 1);
                }
                this.insertLiteralWord(1L << i2 % 64);
                return;
            }
            if (this.rlw.getNumberOfLiteralWords() == 0) {
                this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
                this.insertLiteralWord(1L << i2 % 64);
                return;
            }
            this.buffer.orLastWord(1L << i2 % 64);
            if (this.buffer.getLastWord() == -1L) {
                this.buffer.removeLastWord();
                this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                this.insertEmptyWord(true);
            }
        } else if (dist > 0) {
            this.fastaddStreamOfEmptyWords(false, dist);
        }
    }

    private void locateAndSet(int i2, boolean value2) {
        long lw;
        int nbits = 0;
        int siw = this.buffer.sizeInWords();
        for (int pos = 0; pos < siw; pos += (int)(lw + 1L)) {
            long rl = RunningLengthWord.getRunningLength(this.buffer, pos);
            boolean rb = RunningLengthWord.getRunningBit(this.buffer, pos);
            lw = RunningLengthWord.getNumberOfLiteralWords(this.buffer, pos);
            long rbits = rl * 64L;
            if ((long)i2 < (long)nbits + rbits) {
                this.setInRunningLength(value2, i2, nbits, pos, rl, rb, lw);
                return;
            }
            long lbits = lw * 64L;
            if ((long)i2 < (long)(nbits += (int)rbits) + lbits) {
                this.setInLiteralWords(value2, i2, nbits, pos, rl, rb, lw);
                return;
            }
            nbits += (int)lbits;
        }
    }

    private void setInRunningLength(boolean value2, int i2, int nbits, int pos, long rl, boolean rb, long lw) {
        if (value2 != rb) {
            int wordPosition = (i2 - nbits) / 64 + 1;
            int addedWords = (long)wordPosition == rl ? 1 : 2;
            this.buffer.expand(pos + 1, addedWords);
            long mask = 1L << i2 % 64;
            this.buffer.setWord(pos + 1, value2 ? mask : mask ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.rlw.position >= pos + 1) {
                this.rlw.position += addedWords;
            }
            if (addedWords == 1) {
                this.setRLWInfo(pos, rb, rl - 1L, lw + 1L);
            } else {
                this.setRLWInfo(pos, rb, wordPosition - 1, 1L);
                this.setRLWInfo(pos + 2, rb, rl - (long)wordPosition, lw);
                if (this.rlw.position == pos) {
                    this.rlw.position += 2;
                }
            }
        }
    }

    private void setInLiteralWords(boolean value2, int i2, int nbits, int pos, long rl, boolean rb, long lw) {
        long emptyWord;
        int wordPosition = (i2 - nbits) / 64 + 1;
        long mask = 1L << i2 % 64;
        if (value2) {
            this.buffer.orWord(pos + wordPosition, mask);
        } else {
            this.buffer.andWord(pos + wordPosition, mask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        long l = emptyWord = value2 ? -1L : 0L;
        if (this.buffer.getWord(pos + wordPosition) == emptyWord) {
            boolean canMergeInCurrentRLW = this.mergeLiteralWordInCurrentRunningLength(value2, rb, rl, wordPosition);
            boolean canMergeInNextRLW = this.mergeLiteralWordInNextRunningLength(value2, lw, pos, wordPosition);
            if (canMergeInCurrentRLW && canMergeInNextRLW) {
                long nextRl = RunningLengthWord.getRunningLength(this.buffer, pos + 2);
                long nextLw = RunningLengthWord.getNumberOfLiteralWords(this.buffer, pos + 2);
                this.buffer.collapse(pos, 2);
                this.setRLWInfo(pos, value2, rl + 1L + nextRl, nextLw);
                if (this.rlw.position >= pos + 2) {
                    this.rlw.position -= 2;
                }
            } else if (canMergeInCurrentRLW) {
                this.buffer.collapse(pos + 1, 1);
                this.setRLWInfo(pos, value2, rl + 1L, lw - 1L);
                if (this.rlw.position >= pos + 2) {
                    --this.rlw.position;
                }
            } else if (canMergeInNextRLW) {
                int nextRLWPos = (int)((long)pos + lw + 1L);
                long nextRl = RunningLengthWord.getRunningLength(this.buffer, nextRLWPos);
                long nextLw = RunningLengthWord.getNumberOfLiteralWords(this.buffer, nextRLWPos);
                this.buffer.collapse(pos + wordPosition, 1);
                this.setRLWInfo(pos, rb, rl, lw - 1L);
                this.setRLWInfo(pos + wordPosition, value2, nextRl + 1L, nextLw);
                if (this.rlw.position >= nextRLWPos) {
                    this.rlw.position = (int)((long)this.rlw.position - (lw + 1L - (long)wordPosition));
                }
            } else {
                this.setRLWInfo(pos, rb, rl, wordPosition - 1);
                this.setRLWInfo(pos + wordPosition, value2, 1L, lw - (long)wordPosition);
                if (this.rlw.position == pos) {
                    this.rlw.position += wordPosition;
                }
            }
        }
    }

    private boolean mergeLiteralWordInCurrentRunningLength(boolean value2, boolean rb, long rl, int wordPosition) {
        return (value2 == rb || rl == 0L) && wordPosition == 1;
    }

    private boolean mergeLiteralWordInNextRunningLength(boolean value2, long lw, int pos, int wordPosition) {
        int nextRLWPos = (int)((long)pos + lw + 1L);
        if (lw == (long)wordPosition && nextRLWPos < this.buffer.sizeInWords()) {
            long nextRl = RunningLengthWord.getRunningLength(this.buffer, nextRLWPos);
            boolean nextRb = RunningLengthWord.getRunningBit(this.buffer, nextRLWPos);
            return value2 == nextRb || nextRl == 0L;
        }
        return false;
    }

    private void setRLWInfo(int pos, boolean rb, long rl, long lw) {
        RunningLengthWord.setRunningBit(this.buffer, pos, rb);
        RunningLengthWord.setRunningLength(this.buffer, pos, rl);
        RunningLengthWord.setNumberOfLiteralWords(this.buffer, pos, lw);
    }

    @Override
    public void setSizeInBitsWithinLastWord(int size2) {
        if ((size2 + 64 - 1) / 64 > (this.sizeInBits + 64 - 1) / 64) {
            this.setSizeInBits(size2, false);
            return;
        }
        if ((size2 + 64 - 1) / 64 != (this.sizeInBits + 64 - 1) / 64) {
            throw new RuntimeException("You can only reduce the size of the bitmap within the scope of the last word. To extend the bitmap, please call setSizeInBits(int,boolean).");
        }
        this.sizeInBits = size2;
        int usedBitsInLast = this.sizeInBits % 64;
        if (usedBitsInLast == 0) {
            return;
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            if (this.rlw.getRunningLength() > 0L) {
                this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
                long word = this.rlw.getRunningBit() ? -1L >>> 64 - usedBitsInLast : 0L;
                this.insertLiteralWord(word);
            }
            return;
        }
        this.buffer.andLastWord(-1L >>> 64 - usedBitsInLast);
    }

    public boolean setSizeInBits(int size2, boolean defaultValue) {
        if (size2 <= this.sizeInBits) {
            return false;
        }
        if (this.sizeInBits % 64 != 0) {
            if (!defaultValue) {
                if (this.rlw.getNumberOfLiteralWords() > 0) {
                    int bitsToAdd = size2 - this.sizeInBits;
                    int usedBitsInLast = this.sizeInBits % 64;
                    int freeBitsInLast = 64 - usedBitsInLast;
                    if (this.buffer.getLastWord() == 0L) {
                        this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                        this.buffer.removeLastWord();
                        this.sizeInBits -= usedBitsInLast;
                    } else if (usedBitsInLast > 0) {
                        this.sizeInBits += Math.min(bitsToAdd, freeBitsInLast);
                    }
                }
            } else {
                if (this.rlw.getNumberOfLiteralWords() == 0) {
                    this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
                    this.insertLiteralWord(0L);
                }
                int maskWidth = Math.min(64 - this.sizeInBits % 64, size2 - this.sizeInBits);
                int maskShift = this.sizeInBits % 64;
                long mask = -1L >>> 64 - maskWidth << maskShift;
                this.buffer.orLastWord(mask);
                if (this.buffer.getLastWord() == -1L) {
                    this.buffer.removeLastWord();
                    this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                    this.insertEmptyWord(true);
                }
                this.sizeInBits += maskWidth;
            }
        }
        this.addStreamOfEmptyWords(defaultValue, size2 / 64 - this.sizeInBits / 64);
        if (this.sizeInBits < size2) {
            int dist = this.distanceInWords(size2 - 1);
            if (dist > 0) {
                this.insertLiteralWord(0L);
            }
            if (defaultValue) {
                int maskWidth = size2 - this.sizeInBits;
                int maskShift = this.sizeInBits % 64;
                long mask = -1L >>> 64 - maskWidth << maskShift;
                this.buffer.orLastWord(mask);
            }
            this.sizeInBits = size2;
        }
        return true;
    }

    private int distanceInWords(int i2) {
        return (i2 + 64) / 64 - (this.sizeInBits + 64 - 1) / 64;
    }

    @Override
    public int sizeInBits() {
        return this.sizeInBits;
    }

    @Override
    public int sizeInBytes() {
        return this.buffer.sizeInWords() * 8;
    }

    public static EWAHCompressedBitmap threshold(int t2, EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        EWAHCompressedBitmap.thresholdWithContainer(container, t2, bitmaps);
        return container;
    }

    static int maxSizeInBits(EWAHCompressedBitmap ... bitmaps) {
        int maxSizeInBits = 0;
        for (EWAHCompressedBitmap bitmap : bitmaps) {
            maxSizeInBits = Math.max(maxSizeInBits, bitmap.sizeInBits());
        }
        return maxSizeInBits;
    }

    public static void thresholdWithContainer(BitmapStorage container, int t2, EWAHCompressedBitmap ... bitmaps) {
        new RunningBitmapMerge().symmetric(new ThresholdFuncBitmap(t2), container, bitmaps);
    }

    public int[] toArray() {
        int[] ans = new int[this.cardinality()];
        int inAnsPos = 0;
        int pos = 0;
        EWAHIterator i2 = this.getEWAHIterator();
        while (i2.hasNext()) {
            RunningLengthWord localRlw = i2.next();
            long runningLength = localRlw.getRunningLength();
            if (localRlw.getRunningBit()) {
                int j2 = 0;
                while ((long)j2 < runningLength) {
                    for (int c2 = 0; c2 < 64; ++c2) {
                        ans[inAnsPos++] = pos++;
                    }
                    ++j2;
                }
            } else {
                pos = (int)((long)pos + 64L * runningLength);
            }
            int numberOfLiteralWords = localRlw.getNumberOfLiteralWords();
            int literalWords = i2.literalWords();
            for (int j3 = 0; j3 < numberOfLiteralWords; ++j3) {
                long T;
                for (long data2 = i2.buffer().getWord(literalWords + j3); data2 != 0L; data2 ^= T) {
                    T = data2 & -data2;
                    ans[inAnsPos++] = Long.bitCount(T - 1L) + pos;
                }
                pos += 64;
            }
        }
        return ans;
    }

    public String toDebugString() {
        StringBuilder ans = new StringBuilder();
        ans.append("{\"size in bits\":");
        ans.append(this.sizeInBits).append(", \"size in words\":");
        ans.append(this.buffer.sizeInWords()).append(",");
        EWAHIterator i2 = this.getEWAHIterator();
        ans.append(" \"content\": [");
        boolean first2 = true;
        while (i2.hasNext()) {
            long data2;
            RunningLengthWord localrlw = i2.next();
            if (!first2) {
                ans.append(",");
            }
            first2 = false;
            ans.append("[");
            if (localrlw.getRunningBit()) {
                ans.append(localrlw.getRunningLength()).append(",").append(" \"1x11\", ");
            } else {
                ans.append(localrlw.getRunningLength()).append(",").append(" \"0x00\", ");
            }
            ans.append("[");
            int j2 = 0;
            while (j2 + 1 < localrlw.getNumberOfLiteralWords()) {
                data2 = i2.buffer().getWord(i2.literalWords() + j2);
                ans.append("\"0x").append(Long.toHexString(data2)).append("\",");
                ++j2;
            }
            if (j2 < localrlw.getNumberOfLiteralWords()) {
                data2 = i2.buffer().getWord(i2.literalWords() + j2);
                ans.append("\"0x").append(Long.toHexString(data2)).append("\"");
            }
            ans.append("]]");
        }
        ans.append("]}");
        return ans.toString();
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        IntIterator i2 = this.intIterator();
        answer.append("{");
        if (i2.hasNext()) {
            answer.append(i2.next());
        }
        while (i2.hasNext()) {
            answer.append(",");
            answer.append(i2.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public void swap(EWAHCompressedBitmap other) {
        this.buffer.swap(other.buffer);
        int tmp2 = this.rlw.position;
        this.rlw.position = other.rlw.position;
        other.rlw.position = tmp2;
        int tmp3 = this.sizeInBits;
        this.sizeInBits = other.sizeInBits;
        other.sizeInBits = tmp3;
    }

    public void trim() {
        this.buffer.trim();
    }

    @Override
    public EWAHCompressedBitmap xor(EWAHCompressedBitmap a2) {
        int size2 = this.buffer.sizeInWords() + a2.buffer.sizeInWords();
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size2);
        this.xorToContainer(a2, container);
        return container;
    }

    public void xorToContainer(EWAHCompressedBitmap a2, BitmapStorage container) {
        container.clear();
        EWAHIterator i2 = a2.getEWAHIterator();
        EWAHIterator j2 = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i2);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j2);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord predator = i_is_prey ? rlwj : rlwi;
                long index = !predator.getRunningBit() ? prey.discharge(container, predator.getRunningLength()) : prey.dischargeNegated(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(predator.getRunningBit(), predator.getRunningLength() - index);
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k2 = 0; k2 < nbre_literal; ++k2) {
                container.addWord(rlwi.getLiteralWordAt(k2) ^ rlwj.getLiteralWordAt(k2));
            }
            rlwi.discardLiteralWords(nbre_literal);
            rlwj.discardLiteralWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a2.sizeInBits()));
    }

    public int xorCardinality(EWAHCompressedBitmap a2) {
        BitCounter counter2 = new BitCounter();
        this.xorToContainer(a2, counter2);
        return counter2.getCount();
    }

    @Override
    public EWAHCompressedBitmap compose(EWAHCompressedBitmap a2) {
        int size2 = this.buffer.sizeInWords();
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size2);
        this.composeToContainer(a2, container);
        return container;
    }

    public void composeToContainer(EWAHCompressedBitmap a2, EWAHCompressedBitmap container) {
        container.clear();
        ChunkIterator iterator2 = this.chunkIterator();
        ChunkIterator aIterator = a2.chunkIterator();
        int index = 0;
        while (iterator2.hasNext() && aIterator.hasNext()) {
            int length;
            if (!iterator2.nextBit()) {
                length = iterator2.nextLength();
                container.setSizeInBits(index += length, false);
                iterator2.move(length);
                continue;
            }
            length = Math.min(iterator2.nextLength(), aIterator.nextLength());
            container.setSizeInBits(index += length, aIterator.nextBit());
            iterator2.move(length);
            aIterator.move(length);
        }
        container.setSizeInBits(this.sizeInBits, false);
    }

    public static void andWithContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            throw new IllegalArgumentException("Need at least one bitmap");
        }
        if (bitmaps.length == 2) {
            bitmaps[0].andToContainer(bitmaps[1], container);
            return;
        }
        int initialSize = EWAHCompressedBitmap.calculateInitialSize(bitmaps);
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap(initialSize);
        EWAHCompressedBitmap tmp = new EWAHCompressedBitmap(initialSize);
        bitmaps[0].andToContainer(bitmaps[1], answer);
        for (int k2 = 2; k2 < bitmaps.length - 1; ++k2) {
            answer.andToContainer(bitmaps[k2], tmp);
            EWAHCompressedBitmap tmp2 = answer;
            answer = tmp;
            tmp = tmp2;
            tmp.clear();
        }
        answer.andToContainer(bitmaps[bitmaps.length - 1], container);
    }

    private static int calculateInitialSize(EWAHCompressedBitmap ... bitmaps) {
        int initialSize = 0;
        for (EWAHCompressedBitmap bitmap : bitmaps) {
            initialSize = Math.max(bitmap.buffer.sizeInWords(), initialSize);
        }
        return initialSize;
    }

    public static EWAHCompressedBitmap and(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        if (bitmaps.length == 2) {
            return bitmaps[0].and(bitmaps[1]);
        }
        int initialSize = EWAHCompressedBitmap.calculateInitialSize(bitmaps);
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap(initialSize);
        EWAHCompressedBitmap tmp = new EWAHCompressedBitmap(initialSize);
        bitmaps[0].andToContainer(bitmaps[1], answer);
        for (int k2 = 2; k2 < bitmaps.length; ++k2) {
            answer.andToContainer(bitmaps[k2], tmp);
            tmp.swap(answer);
            tmp.clear();
        }
        return answer;
    }

    public static int andCardinality(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0].cardinality();
        }
        BitCounter counter2 = new BitCounter();
        EWAHCompressedBitmap.andWithContainer(counter2, bitmaps);
        return counter2.getCount();
    }

    public static EWAHCompressedBitmap bitmapOf(int ... setBits) {
        EWAHCompressedBitmap a2 = new EWAHCompressedBitmap();
        for (int k2 : setBits) {
            a2.set(k2);
        }
        return a2;
    }

    public static void orWithContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + bitmaps.length);
        }
        FastAggregation.orToContainer(container, bitmaps);
    }

    public static void xorWithContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + bitmaps.length);
        }
        FastAggregation.xorToContainer(container, bitmaps);
    }

    public static EWAHCompressedBitmap or(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        int largestSize = EWAHCompressedBitmap.calculateInitialSize(bitmaps);
        EWAHCompressedBitmap container = new EWAHCompressedBitmap((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap.orWithContainer(container, bitmaps);
        return container;
    }

    public static EWAHCompressedBitmap xor(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        int largestSize = EWAHCompressedBitmap.calculateInitialSize(bitmaps);
        int size2 = (int)((double)largestSize * 1.5);
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size2);
        EWAHCompressedBitmap.xorWithContainer(container, bitmaps);
        return container;
    }

    public static int orCardinality(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0].cardinality();
        }
        BitCounter counter2 = new BitCounter();
        EWAHCompressedBitmap.orWithContainer(counter2, bitmaps);
        return counter2.getCount();
    }

    public EWAHCompressedBitmap shift(int b2) {
        if (b2 < 0) {
            throw new IllegalArgumentException("Negative shifts unsupported at the moment.");
        }
        int sz = this.buffer.sizeInWords();
        int newsz = b2 > 0 ? sz + (b2 + 63) / 64 : sz;
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap(newsz);
        IteratingRLW i2 = this.getIteratingRLW();
        int fullwords = b2 / 64;
        int shift = b2 % 64;
        answer.addStreamOfEmptyWords(false, fullwords);
        if (shift == 0) {
            do {
                long rl;
                if ((rl = i2.getRunningLength()) > 0L) {
                    answer.addStreamOfEmptyWords(i2.getRunningBit(), rl);
                }
                int x = i2.getNumberOfLiteralWords();
                for (int k2 = 0; k2 < x; ++k2) {
                    answer.addWord(i2.getLiteralWordAt(k2));
                }
            } while (i2.next());
        } else {
            boolean shiftextension = (this.sizeInBits + 64 - 1) % 64 + shift >= 64;
            long w = 0L;
            do {
                long rl;
                if ((rl = i2.getRunningLength()) > 0L) {
                    if (i2.getRunningBit()) {
                        long sw = w | -1L << shift;
                        answer.addWord(sw);
                        w = -1L >>> 64 - shift;
                    } else {
                        answer.addWord(w);
                        w = 0L;
                    }
                    if (rl > 1L) {
                        answer.addStreamOfEmptyWords(i2.getRunningBit(), rl - 1L);
                    }
                }
                int x = i2.getNumberOfLiteralWords();
                for (int k3 = 0; k3 < x; ++k3) {
                    long neww = i2.getLiteralWordAt(k3);
                    long sw = w | neww << shift;
                    answer.addWord(sw);
                    w = neww >>> 64 - shift;
                }
            } while (i2.next());
            if (shiftextension) {
                answer.addWord(w);
            }
        }
        answer.sizeInBits = this.sizeInBits + b2;
        return answer;
    }
}

