/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.IntIteratorOverIteratingRLW;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.IteratingRLW;
import java.util.Iterator;

public final class IteratorUtil {
    private IteratorUtil() {
    }

    public static IntIterator toSetBitsIntIterator(IteratingRLW i2) {
        return new IntIteratorOverIteratingRLW(i2);
    }

    public static Iterator<Integer> toSetBitsIterator(final IteratingRLW i2) {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = IteratorUtil.toSetBitsIntIterator(i2);
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public Integer next() {
                return this.under.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    public static void materialize(IteratingRLW i2, BitmapStorage c2) {
        do {
            if (i2.getRunningLength() > 0L) {
                c2.addStreamOfEmptyWords(i2.getRunningBit(), i2.getRunningLength());
            }
            int il = i2.getNumberOfLiteralWords();
            for (int k2 = 0; k2 < il; ++k2) {
                c2.addWord(i2.getLiteralWordAt(k2));
            }
        } while (i2.next());
    }

    public static int cardinality(IteratingRLW i2) {
        int answer = 0;
        do {
            if (i2.getRunningBit()) {
                answer += (int)(i2.getRunningLength() * 64L);
            }
            int lw = i2.getNumberOfLiteralWords();
            for (int k2 = 0; k2 < lw; ++k2) {
                answer += Long.bitCount(i2.getLiteralWordAt(k2));
            }
        } while (i2.next());
        return answer;
    }

    public static IteratingRLW[] toIterators(EWAHCompressedBitmap ... x) {
        IteratingRLW[] X = new IteratingRLW[x.length];
        for (int k2 = 0; k2 < X.length; ++k2) {
            X[k2] = new IteratingBufferedRunningLengthWord(x[k2]);
        }
        return X;
    }

    public static long materialize(IteratingRLW i2, BitmapStorage c2, long max2) {
        long origMax = max2;
        do {
            long L;
            if (i2.getRunningLength() > 0L) {
                L = i2.getRunningLength();
                if (L > max2) {
                    L = max2;
                }
                c2.addStreamOfEmptyWords(i2.getRunningBit(), L);
                max2 -= L;
            }
            L = i2.getNumberOfLiteralWords();
            int k2 = 0;
            while ((long)k2 < L) {
                c2.addWord(i2.getLiteralWordAt(k2));
                ++k2;
            }
        } while (max2 > 0L && i2.next());
        return origMax - max2;
    }

    public static EWAHCompressedBitmap materialize(IteratingRLW i2) {
        EWAHCompressedBitmap ewah = new EWAHCompressedBitmap();
        IteratorUtil.materialize(i2, ewah);
        return ewah;
    }
}

