/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.datastructure;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.datastructure.WordArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;

public class BitSet
implements Cloneable,
Iterable<Integer>,
Externalizable,
WordArray {
    long[] data;
    static final long serialVersionUID = 7997698588986878754L;

    public BitSet(int sizeInBits) {
        this.data = new long[(sizeInBits + 63) / 64];
    }

    public BitSet() {
        this.data = new long[0];
    }

    public void and(WordArray bs) {
        for (int k2 = 0; k2 < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k2) {
            int n = k2;
            this.data[n] = this.data[n] & bs.getWord(k2);
        }
    }

    public int andcardinality(WordArray bs) {
        int sum = 0;
        for (int k2 = 0; k2 < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k2) {
            sum += Long.bitCount(this.getWord(k2) & bs.getWord(k2));
        }
        return sum;
    }

    public void andNot(WordArray bs) {
        for (int k2 = 0; k2 < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k2) {
            int n = k2;
            this.data[n] = this.data[n] & (bs.getWord(k2) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public int andNotcardinality(WordArray bs) {
        int sum = 0;
        for (int k2 = 0; k2 < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k2) {
            sum += Long.bitCount(this.getWord(k2) & (bs.getWord(k2) ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return sum;
    }

    public int cardinality() {
        int sum = 0;
        for (long l : this.data) {
            sum += Long.bitCount(l);
        }
        return sum;
    }

    public void clear() {
        Arrays.fill(this.data, 0L);
    }

    public void clear(int index) {
        this.unset(index);
    }

    public void clear(int start2, int end2) {
        if (start2 == end2) {
            return;
        }
        int firstword = start2 / 64;
        int endword = (end2 - 1) / 64;
        if (firstword == endword) {
            int n = firstword;
            this.data[n] = this.data[n] & (-1L << start2 & -1L >>> -end2 ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        int n = firstword;
        this.data[n] = this.data[n] & (-1L << start2 ^ 0xFFFFFFFFFFFFFFFFL);
        for (int i2 = firstword + 1; i2 < endword; ++i2) {
            this.data[i2] = 0L;
        }
        int n2 = endword;
        this.data[n2] = this.data[n2] & (-1L >>> -end2 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public BitSet clone() {
        try {
            BitSet b2 = (BitSet)super.clone();
            b2.data = Arrays.copyOf(this.data, this.getNumberOfWords());
            return b2;
        }
        catch (CloneNotSupportedException e2) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof WordArray) {
            WordArray bs = (WordArray)o;
            for (int k2 = 0; k2 < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k2) {
                if (this.getWord(k2) == bs.getWord(k2)) continue;
                return false;
            }
            WordArray longer = bs.getNumberOfWords() < this.getNumberOfWords() ? this : bs;
            for (int k3 = Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); k3 < Math.max(this.getNumberOfWords(), bs.getNumberOfWords()); ++k3) {
                if (longer.getWord(k3) == 0L) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean empty() {
        for (long l : this.data) {
            if (l == 0L) continue;
            return false;
        }
        return true;
    }

    public void flip(int i2) {
        int n = i2 / 64;
        this.data[n] = this.data[n] ^ 1L << i2 % 64;
    }

    public void flip(int start2, int end2) {
        if (start2 == end2) {
            return;
        }
        int firstword = start2 / 64;
        int endword = (end2 - 1) / 64;
        int n = firstword;
        this.data[n] = this.data[n] ^ (-1L << start2 ^ 0xFFFFFFFFFFFFFFFFL);
        for (int i2 = firstword; i2 < endword; ++i2) {
            this.data[i2] = this.data[i2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n2 = endword;
        this.data[n2] = this.data[n2] ^ -1L >>> -end2;
    }

    public boolean get(int i2) {
        return (this.data[i2 / 64] & 1L << i2 % 64) != 0L;
    }

    public int hashCode() {
        int b2 = 31;
        long hash = 0L;
        for (int k2 = 0; k2 < this.data.length; ++k2) {
            long aData = this.getWord(k2);
            hash = hash * (long)b2 + aData;
        }
        return (int)hash;
    }

    public IntIterator intIterator() {
        return new IntIterator(){
            private int i;
            private int j;
            {
                this.i = BitSet.this.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public int next() {
                this.j = this.i;
                this.i = BitSet.this.nextSetBit(this.i + 1);
                return this.j;
            }
        };
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int i;
            private int j;
            {
                this.i = BitSet.this.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public Integer next() {
                this.j = this.i;
                this.i = BitSet.this.nextSetBit(this.i + 1);
                return this.j;
            }

            @Override
            public void remove() {
                BitSet.this.unset(this.j);
            }
        };
    }

    public boolean intersects(WordArray bs) {
        for (int k2 = 0; k2 < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k2) {
            if ((this.getWord(k2) & bs.getWord(k2)) == 0L) continue;
            return true;
        }
        return false;
    }

    public int nextSetBit(int i2) {
        int x = i2 / 64;
        if (x >= this.getNumberOfWords()) {
            return -1;
        }
        long w = this.data[x];
        if ((w >>>= i2) != 0L) {
            return i2 + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.getNumberOfWords()) {
            if (this.data[x] != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(this.data[x]);
            }
            ++x;
        }
        return -1;
    }

    public int nextUnsetBit(int i2) {
        int x = i2 / 64;
        if (x >= this.getNumberOfWords()) {
            return -1;
        }
        long w = this.data[x] ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w >>>= i2) != 0L) {
            return i2 + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.getNumberOfWords()) {
            if (this.data[x] != -1L) {
                return x * 64 + Long.numberOfTrailingZeros(this.data[x] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++x;
        }
        return -1;
    }

    public void or(WordArray bs) {
        if (this.getNumberOfWords() < bs.getNumberOfWords()) {
            this.resize(bs.getNumberOfWords() * 64);
        }
        for (int k2 = 0; k2 < this.getNumberOfWords(); ++k2) {
            int n = k2;
            this.data[n] = this.data[n] | bs.getWord(k2);
        }
    }

    public int orcardinality(WordArray bs) {
        int sum = 0;
        for (int k2 = 0; k2 < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k2) {
            sum += Long.bitCount(this.getWord(k2) | bs.getWord(k2));
        }
        WordArray longer = bs.getNumberOfWords() < this.getNumberOfWords() ? this : bs;
        for (int k3 = Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); k3 < Math.max(this.getNumberOfWords(), bs.getNumberOfWords()); ++k3) {
            sum += Long.bitCount(longer.getWord(k3));
        }
        return sum;
    }

    public void removeWord(int i2) {
        long[] newdata = new long[this.data.length - 1];
        if (i2 == 0) {
            System.arraycopy(this.data, 1, newdata, 0, i2 - 1);
        }
        System.arraycopy(this.data, 0, newdata, 0, i2 - 1);
        System.arraycopy(this.data, i2, newdata, i2 - 1, this.data.length - i2);
        this.data = newdata;
    }

    public void resize(int sizeInBits) {
        this.data = Arrays.copyOf(this.data, (sizeInBits + 63) / 64);
    }

    public void set(int i2) {
        int n = i2 / 64;
        this.data[n] = this.data[n] | 1L << i2 % 64;
    }

    public void set(int i2, boolean b2) {
        if (b2) {
            this.set(i2);
        } else {
            this.unset(i2);
        }
    }

    public void set(int start2, int end2) {
        if (start2 == end2) {
            return;
        }
        int firstword = start2 / 64;
        int endword = (end2 - 1) / 64;
        if (firstword == endword) {
            int n = firstword;
            this.data[n] = this.data[n] | -1L << start2 & -1L >>> -end2;
            return;
        }
        int n = firstword;
        this.data[n] = this.data[n] | -1L << start2;
        for (int i2 = firstword + 1; i2 < endword; ++i2) {
            this.data[i2] = -1L;
        }
        int n2 = endword;
        this.data[n2] = this.data[n2] | -1L >>> -end2;
    }

    public void set(int start2, int end2, boolean v) {
        if (v) {
            this.set(start2, end2);
        } else {
            this.clear(start2, end2);
        }
    }

    public int size() {
        return this.getNumberOfWords() * 64;
    }

    public void trim() {
        for (int k2 = this.getNumberOfWords() - 1; k2 >= 0; --k2) {
            if (this.getWord(k2) == 0L) continue;
            if (k2 + 1 < this.getNumberOfWords()) {
                this.data = Arrays.copyOf(this.data, k2 + 1);
            }
            return;
        }
        this.data = new long[0];
    }

    public void unset(int i2) {
        int n = i2 / 64;
        this.data[n] = this.data[n] & (1L << i2 % 64 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public IntIterator unsetIntIterator() {
        return new IntIterator(){
            private int i;
            private int j;
            {
                this.i = BitSet.this.nextUnsetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public int next() {
                this.j = this.i;
                this.i = BitSet.this.nextUnsetBit(this.i + 1);
                return this.j;
            }
        };
    }

    @Override
    public void writeExternal(ObjectOutput out2) throws IOException {
        this.serialize(out2);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    public void serialize(DataOutput out2) throws IOException {
        out2.writeLong(this.getNumberOfWords());
        for (long w : this.data) {
            out2.writeLong(w);
        }
    }

    public void deserialize(DataInput in) throws IOException {
        int length = (int)in.readLong();
        this.data = new long[length];
        for (int k2 = 0; k2 < length; ++k2) {
            this.data[k2] = in.readLong();
        }
    }

    public void xor(WordArray bs) {
        if (this.getNumberOfWords() < bs.getNumberOfWords()) {
            this.resize(bs.getNumberOfWords() * 64);
        }
        for (int k2 = 0; k2 < this.getNumberOfWords(); ++k2) {
            int n = k2;
            this.data[n] = this.data[n] ^ bs.getWord(k2);
        }
    }

    public int xorcardinality(WordArray bs) {
        int sum = 0;
        for (int k2 = 0; k2 < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k2) {
            sum += Long.bitCount(this.getWord(k2) ^ bs.getWord(k2));
        }
        WordArray longer = bs.getNumberOfWords() < this.getNumberOfWords() ? this : bs;
        int start2 = Math.min(this.getNumberOfWords(), bs.getNumberOfWords());
        int end2 = Math.max(this.getNumberOfWords(), bs.getNumberOfWords());
        for (int k3 = start2; k3 < end2; ++k3) {
            sum += Long.bitCount(longer.getWord(k3));
        }
        return sum;
    }

    @Override
    public int getNumberOfWords() {
        return this.data.length;
    }

    @Override
    public long getWord(int index) {
        return this.data[index];
    }

    public static BitSet bitmapOf(int ... setBits) {
        int maxv = 0;
        for (int k2 : setBits) {
            if (maxv >= k2) continue;
            maxv = k2;
        }
        BitSet a2 = new BitSet(maxv + 1);
        for (int k3 : setBits) {
            a2.set(k3);
        }
        return a2;
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        IntIterator i2 = this.intIterator();
        answer.append("{");
        if (i2.hasNext()) {
            answer.append(i2.next());
        }
        while (i2.hasNext()) {
            answer.append(",");
            answer.append(i2.next());
        }
        answer.append("}");
        return answer.toString();
    }
}

