/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.datastructure;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.datastructure.BitSet;
import com.googlecode.javaewah.datastructure.WordArray;
import java.nio.LongBuffer;
import java.util.Iterator;

public class ImmutableBitSet
implements Cloneable,
Iterable<Integer>,
WordArray {
    private LongBuffer data;

    public ImmutableBitSet(LongBuffer bs) {
        int length = (int)bs.get(0);
        LongBuffer copy2 = bs.slice();
        copy2.position(1);
        this.data = copy2.slice();
        this.data.limit(length);
    }

    public BitSet asBitSet() {
        BitSet bs = new BitSet(this.size());
        this.data.rewind();
        this.data.get(bs.data, 0, bs.data.length);
        return bs;
    }

    public int cardinality() {
        int sum = 0;
        int length = this.data.limit();
        for (int k2 = 0; k2 < length; ++k2) {
            sum += Long.bitCount(this.data.get(k2));
        }
        return sum;
    }

    public ImmutableBitSet clone() {
        try {
            ImmutableBitSet b2 = (ImmutableBitSet)super.clone();
            b2.data = this.data.duplicate();
            return b2;
        }
        catch (CloneNotSupportedException e2) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof WordArray) {
            WordArray bs = (WordArray)o;
            for (int k2 = 0; k2 < Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); ++k2) {
                if (this.getWord(k2) == bs.getWord(k2)) continue;
                return false;
            }
            WordArray longer = bs.getNumberOfWords() < this.getNumberOfWords() ? this : bs;
            for (int k3 = Math.min(this.getNumberOfWords(), bs.getNumberOfWords()); k3 < Math.max(this.getNumberOfWords(), bs.getNumberOfWords()); ++k3) {
                if (longer.getWord(k3) == 0L) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean empty() {
        int length = this.data.limit();
        for (int k2 = 0; k2 < length; ++k2) {
            if (this.data.get(k2) == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean get(int i2) {
        return (this.data.get(i2 / 64) & 1L << i2 % 64) != 0L;
    }

    public int hashCode() {
        int b2 = 31;
        long hash = 0L;
        int length = this.data.limit();
        for (int k2 = 0; k2 < length; ++k2) {
            long aData = this.data.get(k2);
            hash = hash * (long)b2 + aData;
        }
        return (int)hash;
    }

    public IntIterator intIterator() {
        return new IntIterator(){
            private int i;
            private int j;
            {
                this.i = ImmutableBitSet.this.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public int next() {
                this.j = this.i;
                this.i = ImmutableBitSet.this.nextSetBit(this.i + 1);
                return this.j;
            }
        };
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int i;
            private int j;
            {
                this.i = ImmutableBitSet.this.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public Integer next() {
                this.j = this.i;
                this.i = ImmutableBitSet.this.nextSetBit(this.i + 1);
                return this.j;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Object is immutable");
            }
        };
    }

    public boolean intersects(BitSet bs) {
        for (int k2 = 0; k2 < Math.min(this.data.limit(), bs.data.length); ++k2) {
            if ((this.data.get(k2) & bs.data[k2]) == 0L) continue;
            return true;
        }
        return false;
    }

    public int nextSetBit(int i2) {
        int x = i2 / 64;
        if (x >= this.data.limit()) {
            return -1;
        }
        long w = this.data.get(x);
        if ((w >>>= i2 % 64) != 0L) {
            return i2 + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.data.limit()) {
            if (this.data.get(x) != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(this.data.get(x));
            }
            ++x;
        }
        return -1;
    }

    public int nextUnsetBit(int i2) {
        int x = i2 / 64;
        if (x >= this.data.limit()) {
            return -1;
        }
        long w = this.data.get(x) ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w >>>= i2 % 64) != 0L) {
            return i2 + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.data.limit()) {
            if (this.data.get(x) != -1L) {
                return x * 64 + Long.numberOfTrailingZeros(this.data.get(x) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++x;
        }
        return -1;
    }

    public int size() {
        return this.data.limit() * 64;
    }

    public IntIterator unsetIntIterator() {
        return new IntIterator(){
            private int i;
            private int j;
            {
                this.i = ImmutableBitSet.this.nextUnsetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public int next() {
                this.j = this.i;
                this.i = ImmutableBitSet.this.nextUnsetBit(this.i + 1);
                return this.j;
            }
        };
    }

    @Override
    public int getNumberOfWords() {
        return this.data.limit();
    }

    @Override
    public long getWord(int index) {
        return this.data.get(index);
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        IntIterator i2 = this.intIterator();
        answer.append("{");
        if (i2.hasNext()) {
            answer.append(i2.next());
        }
        while (i2.hasNext()) {
            answer.append(",");
            answer.append(i2.next());
        }
        answer.append("}");
        return answer.toString();
    }
}

