/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.datastructure;

import java.util.Comparator;

public final class PriorityQ<T> {
    final T[] a;
    int lastIndex;
    final Comparator<T> comp;

    public PriorityQ(int maxSize2, Comparator<T> c2) {
        this.a = new Object[maxSize2 + 1];
        this.lastIndex = 0;
        this.comp = c2;
    }

    public int size() {
        return this.lastIndex;
    }

    private int compare(T a2, T b2) {
        return this.comp.compare(a2, b2);
    }

    public void toss(T t2) {
        this.a[++this.lastIndex] = t2;
    }

    public T peek() {
        return this.a[1];
    }

    public void buildHeap() {
        for (int i2 = this.lastIndex / 2; i2 > 0; --i2) {
            this.percolateDown(i2);
        }
    }

    public void percolateDown() {
        this.percolateDown(1);
    }

    private void percolateDown(int i2) {
        T ai = this.a[i2];
        while (true) {
            int l = 2 * i2;
            int r = l + 1;
            int smallest = i2;
            if (r <= this.lastIndex) {
                if (this.compare(this.a[l], ai) < 0) {
                    smallest = l;
                    if (this.compare(this.a[r], this.a[smallest]) < 0) {
                        smallest = r;
                    }
                } else if (this.compare(this.a[r], ai) < 0) {
                    smallest = r;
                }
            } else if (l <= this.lastIndex && this.compare(this.a[l], ai) < 0) {
                smallest = l;
            }
            if (i2 == smallest) break;
            this.a[i2] = this.a[smallest];
            i2 = smallest;
        }
        this.a[smallest] = ai;
    }

    public T poll() {
        T ans = this.a[1];
        this.a[1] = this.a[this.lastIndex--];
        this.percolateDown(1);
        return ans;
    }

    public boolean isEmpty() {
        return this.lastIndex == 0;
    }
}

