/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.symmetric;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.datastructure.PriorityQ;
import com.googlecode.javaewah.symmetric.BitmapSymmetricAlgorithm;
import com.googlecode.javaewah.symmetric.EWAHPointer;
import com.googlecode.javaewah.symmetric.UpdateableBitmapFunction;
import java.util.Comparator;

public class RunningBitmapMerge
implements BitmapSymmetricAlgorithm {
    @Override
    public void symmetric(UpdateableBitmapFunction f2, BitmapStorage out2, EWAHCompressedBitmap ... set2) {
        out2.clear();
        PriorityQ<EWAHPointer> h2 = new PriorityQ<EWAHPointer>(set2.length, new Comparator<EWAHPointer>(){

            @Override
            public int compare(EWAHPointer arg0, EWAHPointer arg1) {
                return arg0.compareTo(arg1);
            }
        });
        f2.resize(set2.length);
        for (int k2 = 0; k2 < set2.length; ++k2) {
            EWAHPointer x = new EWAHPointer(0, new IteratingBufferedRunningLengthWord(set2[k2]), k2);
            if (x.hasNoData()) continue;
            f2.rw[k2] = x;
            x.callbackUpdate(f2);
            h2.toss(x);
        }
        h2.buildHeap();
        int lasta = 0;
        if (h2.isEmpty()) {
            return;
        }
        block1: while (true) {
            int a2 = h2.peek().endOfRun();
            f2.dispatch(out2, lasta, a2);
            lasta = a2;
            while (true) {
                if (h2.peek().endOfRun() != a2) continue block1;
                EWAHPointer p = h2.peek();
                p.parseNextRun();
                p.callbackUpdate(f2);
                if (p.hasNoData()) {
                    h2.poll();
                    if (!h2.isEmpty()) continue;
                    break block1;
                }
                h2.percolateDown();
            }
            break;
        }
    }
}

