/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.symmetric;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.symmetric.EWAHPointer;
import com.googlecode.javaewah.symmetric.UpdateableBitmapFunction;
import java.util.Arrays;

public final class ThresholdFuncBitmap
extends UpdateableBitmapFunction {
    private final int min;
    private long[] buffers;
    private int bufferUsed;
    private final int[] bufCounters = new int[64];
    private static final int[] zeroes64 = new int[64];

    public ThresholdFuncBitmap(int min2) {
        this.min = min2;
        this.buffers = new long[16];
        this.bufferUsed = 0;
    }

    @Override
    public void dispatch(BitmapStorage out2, int runBegin, int runEnd) {
        int runLength = runEnd - runBegin;
        if (this.hammingWeight >= this.min) {
            out2.addStreamOfEmptyWords(true, runLength);
        } else if (this.litWeight + this.hammingWeight < this.min) {
            out2.addStreamOfEmptyWords(false, runLength);
        } else {
            int deficit = this.min - this.hammingWeight;
            if (deficit == 1) {
                this.orLiterals(out2, runBegin, runLength);
                return;
            }
            this.bufferUsed = this.getNumberOfLiterals();
            if (this.bufferUsed == deficit) {
                this.andLiterals(out2, runBegin, runLength);
            } else {
                this.generalLiterals(deficit, out2, runBegin, runLength);
            }
        }
    }

    private long threshold2buf(int t2, long[] buf, int bufUsed) {
        long result2 = 0L;
        int[] counters = this.bufCounters;
        System.arraycopy(zeroes64, 0, counters, 0, 64);
        for (int k2 = 0; k2 < bufUsed; ++k2) {
            long t22;
            for (long bitset = buf[k2]; bitset != 0L; bitset ^= t22) {
                t22 = bitset & -bitset;
                int n = Long.bitCount(t22 - 1L);
                counters[n] = counters[n] + 1;
            }
        }
        for (int pos = 0; pos < 64; ++pos) {
            if (counters[pos] < t2) continue;
            result2 |= 1L << pos;
        }
        return result2;
    }

    private static long threshold3(int t2, long[] buffers, int bufUsed) {
        if (buffers.length == 0) {
            return 0L;
        }
        long[] v = new long[t2];
        v[0] = buffers[0];
        for (int k2 = 1; k2 < bufUsed; ++k2) {
            int m4;
            long c2 = buffers[k2];
            for (int j2 = m4 = Math.min(t2 - 1, k2); j2 >= 1; --j2) {
                int n = j2;
                v[n] = v[n] | c2 & v[j2 - 1];
            }
            v[0] = v[0] | c2;
        }
        return v[t2 - 1];
    }

    private long threshold4(int T, long[] buf, int bufUsed) {
        if (T >= 128) {
            return this.threshold2buf(T, buf, bufUsed);
        }
        int B = 0;
        for (int k2 = 0; k2 < bufUsed; ++k2) {
            B += Long.bitCount(buf[k2]);
        }
        if (2 * B >= bufUsed * T) {
            return ThresholdFuncBitmap.threshold3(T, buf, bufUsed);
        }
        return this.threshold2buf(T, buf, bufUsed);
    }

    private void orLiterals(BitmapStorage out2, int runBegin, int runLength) {
        for (int i2 = 0; i2 < runLength; ++i2) {
            long w = 0L;
            for (EWAHPointer R : this.getLiterals()) {
                w |= R.iterator.getLiteralWordAt(i2 + runBegin - R.beginOfRun());
            }
            out2.addWord(w);
        }
    }

    private void andLiterals(BitmapStorage out2, int runBegin, int runLength) {
        for (int i2 = 0; i2 < runLength; ++i2) {
            long w = -1L;
            for (EWAHPointer R : this.getLiterals()) {
                w &= R.iterator.getLiteralWordAt(i2 + runBegin - R.beginOfRun());
            }
            out2.addWord(w);
        }
    }

    private void generalLiterals(int deficit, BitmapStorage out2, int runBegin, int runLength) {
        if (this.bufferUsed > this.buffers.length) {
            this.buffers = Arrays.copyOf(this.buffers, 2 * this.bufferUsed);
        }
        for (int i2 = 0; i2 < runLength; ++i2) {
            int p = 0;
            for (EWAHPointer R : this.getLiterals()) {
                this.buffers[p++] = R.iterator.getLiteralWordAt(i2 + runBegin - R.beginOfRun());
            }
            out2.addWord(this.threshold4(deficit, this.buffers, this.bufferUsed));
        }
    }
}

