/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.AndIt;
import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.BufferedIterator32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.ORIt;
import com.googlecode.javaewah32.XORIt;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;

public final class IteratorAggregation32 {
    public static final int DEFAULT_MAX_BUF_SIZE = 65536;

    private IteratorAggregation32() {
    }

    public static IteratingRLW32 not(final IteratingRLW32 x) {
        return new IteratingRLW32(){

            @Override
            public boolean next() {
                return x.next();
            }

            @Override
            public int getLiteralWordAt(int index) {
                return ~x.getLiteralWordAt(index);
            }

            @Override
            public int getNumberOfLiteralWords() {
                return x.getNumberOfLiteralWords();
            }

            @Override
            public boolean getRunningBit() {
                return !x.getRunningBit();
            }

            @Override
            public int size() {
                return x.size();
            }

            @Override
            public int getRunningLength() {
                return x.getRunningLength();
            }

            @Override
            public void discardFirstWords(int y) {
                x.discardFirstWords(y);
            }

            @Override
            public void discardRunningWords() {
                x.discardRunningWords();
            }

            @Override
            public IteratingRLW32 clone() throws CloneNotSupportedException {
                throw new CloneNotSupportedException();
            }

            @Override
            public void discardLiteralWords(int y) {
                x.discardLiteralWords(y);
            }
        };
    }

    public static IteratingRLW32 bufferedand(IteratingRLW32 ... al) {
        return IteratorAggregation32.bufferedand(65536, al);
    }

    public static IteratingRLW32 bufferedand(int bufSize, IteratingRLW32 ... al) {
        if (al.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (al.length == 1) {
            return al[0];
        }
        LinkedList<IteratingRLW32> basell = new LinkedList<IteratingRLW32>();
        Collections.addAll(basell, al);
        return new BufferedIterator32(new AndIt(basell, bufSize));
    }

    public static IteratingRLW32 bufferedor(IteratingRLW32 ... al) {
        return IteratorAggregation32.bufferedor(65536, al);
    }

    public static IteratingRLW32 bufferedor(int bufSize, IteratingRLW32 ... al) {
        if (al.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (al.length == 1) {
            return al[0];
        }
        LinkedList<IteratingRLW32> basell = new LinkedList<IteratingRLW32>();
        Collections.addAll(basell, al);
        return new BufferedIterator32(new ORIt(basell, bufSize));
    }

    public static IteratingRLW32 bufferedxor(IteratingRLW32 ... al) {
        return IteratorAggregation32.bufferedxor(65536, al);
    }

    public static IteratingRLW32 bufferedxor(int bufSize, IteratingRLW32 ... al) {
        if (al.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (al.length == 1) {
            return al[0];
        }
        LinkedList<IteratingRLW32> basell = new LinkedList<IteratingRLW32>();
        Collections.addAll(basell, al);
        return new BufferedIterator32(new XORIt(basell, bufSize));
    }

    protected static void dischargeAsEmpty(BitmapStorage32 container, IteratingRLW32 i2) {
        while (i2.size() > 0) {
            container.addStreamOfEmptyWords(false, i2.size());
            i2.next();
        }
    }

    protected static int discharge(BitmapStorage32 container, IteratingRLW32 i2, int max2) {
        int counter2;
        int l;
        for (counter2 = 0; i2.size() > 0 && counter2 < max2; counter2 += l) {
            int l1 = i2.getRunningLength();
            if (l1 > 0) {
                if (l1 + counter2 > max2) {
                    l1 = max2 - counter2;
                }
                container.addStreamOfEmptyWords(i2.getRunningBit(), l1);
                counter2 += l1;
            }
            if ((l = i2.getNumberOfLiteralWords()) + counter2 > max2) {
                l = max2 - counter2;
            }
            for (int k2 = 0; k2 < l; ++k2) {
                container.addWord(i2.getLiteralWordAt(k2));
            }
            i2.discardFirstWords(l + l1);
        }
        return counter2;
    }

    protected static int dischargeNegated(BitmapStorage32 container, IteratingRLW32 i2, int max2) {
        int counter2;
        int l;
        for (counter2 = 0; i2.size() > 0 && counter2 < max2; counter2 += l) {
            int l1 = i2.getRunningLength();
            if (l1 > 0) {
                if (l1 + counter2 > max2) {
                    l1 = max2 - counter2;
                }
                container.addStreamOfEmptyWords(i2.getRunningBit(), l1);
                counter2 += l1;
            }
            if ((l = i2.getNumberOfLiteralWords()) + counter2 > max2) {
                l = max2 - counter2;
            }
            for (int k2 = 0; k2 < l; ++k2) {
                container.addWord(i2.getLiteralWordAt(k2));
            }
            i2.discardFirstWords(l + l1);
        }
        return counter2;
    }

    static void andToContainer(BitmapStorage32 container, int desiredrlwcount, IteratingRLW32 rlwi, IteratingRLW32 rlwj) {
        while (rlwi.size() > 0 && rlwj.size() > 0 && desiredrlwcount-- > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                IteratingRLW32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingRLW32 prey = i_is_prey ? rlwi : rlwj;
                IteratingRLW32 iteratingRLW32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                int index = IteratorAggregation32.discharge(container, prey, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            desiredrlwcount -= nbre_literal;
            for (int k2 = 0; k2 < nbre_literal; ++k2) {
                container.addWord(rlwi.getLiteralWordAt(k2) & rlwj.getLiteralWordAt(k2));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
    }

    static void andToContainer(BitmapStorage32 container, IteratingRLW32 rlwi, IteratingRLW32 rlwj) {
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                IteratingRLW32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingRLW32 prey = i_is_prey ? rlwi : rlwj;
                IteratingRLW32 iteratingRLW32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                int index = IteratorAggregation32.discharge(container, prey, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k2 = 0; k2 < nbre_literal; ++k2) {
                container.addWord(rlwi.getLiteralWordAt(k2) & rlwj.getLiteralWordAt(k2));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
    }

    public static void xorToContainer(BitmapStorage32 container, int desiredrlwcount, IteratingRLW32 rlwi, IteratingRLW32 rlwj) {
        while (rlwi.size() > 0 && rlwj.size() > 0 && desiredrlwcount-- > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                int index;
                IteratingRLW32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingRLW32 prey = i_is_prey ? rlwi : rlwj;
                IteratingRLW32 iteratingRLW32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    index = IteratorAggregation32.discharge(container, prey, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                index = IteratorAggregation32.dischargeNegated(container, prey, predator.getRunningLength());
                container.addStreamOfEmptyWords(true, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            desiredrlwcount -= nbre_literal;
            for (int k2 = 0; k2 < nbre_literal; ++k2) {
                container.addWord(rlwi.getLiteralWordAt(k2) ^ rlwj.getLiteralWordAt(k2));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
    }

    protected static int inplaceor(int[] bitmap, IteratingRLW32 i2) {
        int s2;
        int pos = 0;
        while ((s2 = i2.size()) > 0) {
            int k2;
            if (pos + s2 < bitmap.length) {
                int L = i2.getRunningLength();
                if (i2.getRunningBit()) {
                    Arrays.fill(bitmap, pos, pos + L, -1);
                }
                pos += L;
                int LR = i2.getNumberOfLiteralWords();
                for (k2 = 0; k2 < LR; ++k2) {
                    int n = pos++;
                    bitmap[n] = bitmap[n] | i2.getLiteralWordAt(k2);
                }
                if (i2.next()) continue;
                return pos;
            }
            int howmany = bitmap.length - pos;
            int l = i2.getRunningLength();
            if (pos + l > bitmap.length) {
                if (i2.getRunningBit()) {
                    Arrays.fill(bitmap, pos, bitmap.length, -1);
                }
                i2.discardFirstWords(howmany);
                return bitmap.length;
            }
            if (i2.getRunningBit()) {
                Arrays.fill(bitmap, pos, pos + l, -1);
            }
            pos += l;
            k2 = 0;
            while (pos < bitmap.length) {
                int n = pos++;
                bitmap[n] = bitmap[n] | i2.getLiteralWordAt(k2);
                ++k2;
            }
            i2.discardFirstWords(howmany);
            return pos;
        }
        return pos;
    }

    protected static int inplacexor(int[] bitmap, IteratingRLW32 i2) {
        int s2;
        int pos = 0;
        while ((s2 = i2.size()) > 0) {
            int k2;
            if (pos + s2 < bitmap.length) {
                int L = i2.getRunningLength();
                if (i2.getRunningBit()) {
                    for (int k3 = pos; k3 < pos + L; ++k3) {
                        bitmap[k3] = ~bitmap[k3];
                    }
                }
                pos += L;
                int LR = i2.getNumberOfLiteralWords();
                for (k2 = 0; k2 < LR; ++k2) {
                    int n = pos++;
                    bitmap[n] = bitmap[n] ^ i2.getLiteralWordAt(k2);
                }
                if (i2.next()) continue;
                return pos;
            }
            int howMany = bitmap.length - pos;
            int l = i2.getRunningLength();
            if (pos + l > bitmap.length) {
                if (i2.getRunningBit()) {
                    for (k2 = pos; k2 < bitmap.length; ++k2) {
                        bitmap[k2] = ~bitmap[k2];
                    }
                }
                i2.discardFirstWords(howMany);
                return bitmap.length;
            }
            if (i2.getRunningBit()) {
                for (k2 = pos; k2 < pos + l; ++k2) {
                    bitmap[k2] = ~bitmap[k2];
                }
            }
            pos += l;
            k2 = 0;
            while (pos < bitmap.length) {
                int n = pos++;
                bitmap[n] = bitmap[n] ^ i2.getLiteralWordAt(k2);
                ++k2;
            }
            i2.discardFirstWords(howMany);
            return pos;
        }
        return pos;
    }

    protected static int inplaceand(int[] bitmap, IteratingRLW32 i2) {
        int s2;
        int pos = 0;
        while ((s2 = i2.size()) > 0) {
            int k2;
            if (pos + s2 < bitmap.length) {
                int L = i2.getRunningLength();
                if (!i2.getRunningBit()) {
                    for (int k3 = pos; k3 < pos + L; ++k3) {
                        bitmap[k3] = 0;
                    }
                }
                pos += L;
                int LR = i2.getNumberOfLiteralWords();
                for (k2 = 0; k2 < LR; ++k2) {
                    int n = pos++;
                    bitmap[n] = bitmap[n] & i2.getLiteralWordAt(k2);
                }
                if (i2.next()) continue;
                return pos;
            }
            int howMany = bitmap.length - pos;
            int l = i2.getRunningLength();
            if (pos + l > bitmap.length) {
                if (!i2.getRunningBit()) {
                    for (k2 = pos; k2 < bitmap.length; ++k2) {
                        bitmap[k2] = 0;
                    }
                }
                i2.discardFirstWords(howMany);
                return bitmap.length;
            }
            if (!i2.getRunningBit()) {
                for (k2 = pos; k2 < pos + l; ++k2) {
                    bitmap[k2] = 0;
                }
            }
            pos += l;
            k2 = 0;
            while (pos < bitmap.length) {
                int n = pos++;
                bitmap[n] = bitmap[n] & i2.getLiteralWordAt(k2);
                ++k2;
            }
            i2.discardFirstWords(howMany);
            return pos;
        }
        return pos;
    }
}

