/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.IntIteratorOverIteratingRLW32;
import com.googlecode.javaewah32.IteratingBufferedRunningLengthWord32;
import com.googlecode.javaewah32.IteratingRLW32;
import java.util.Iterator;

public final class IteratorUtil32 {
    private IteratorUtil32() {
    }

    public static IntIterator toSetBitsIntIterator(IteratingRLW32 i2) {
        return new IntIteratorOverIteratingRLW32(i2);
    }

    public static Iterator<Integer> toSetBitsIterator(final IteratingRLW32 i2) {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = IteratorUtil32.toSetBitsIntIterator(i2);
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public Integer next() {
                return this.under.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    public static void materialize(IteratingRLW32 i2, BitmapStorage32 c2) {
        do {
            if (i2.getRunningLength() > 0) {
                c2.addStreamOfEmptyWords(i2.getRunningBit(), i2.getRunningLength());
            }
            int il = i2.getNumberOfLiteralWords();
            for (int k2 = 0; k2 < il; ++k2) {
                c2.addWord(i2.getLiteralWordAt(k2));
            }
        } while (i2.next());
    }

    public static int cardinality(IteratingRLW32 i2) {
        int answer = 0;
        do {
            if (i2.getRunningBit()) {
                answer += i2.getRunningLength() * 32;
            }
            int il = i2.getNumberOfLiteralWords();
            for (int k2 = 0; k2 < il; ++k2) {
                answer += Integer.bitCount(i2.getLiteralWordAt(k2));
            }
        } while (i2.next());
        return answer;
    }

    public static IteratingRLW32[] toIterators(EWAHCompressedBitmap32 ... x) {
        IteratingRLW32[] X = new IteratingRLW32[x.length];
        for (int k2 = 0; k2 < X.length; ++k2) {
            X[k2] = new IteratingBufferedRunningLengthWord32(x[k2]);
        }
        return X;
    }

    public static long materialize(IteratingRLW32 i2, BitmapStorage32 c2, int max2) {
        int origMax = max2;
        do {
            if (i2.getRunningLength() > 0) {
                int l = i2.getRunningLength();
                if (l > max2) {
                    l = max2;
                }
                c2.addStreamOfEmptyWords(i2.getRunningBit(), l);
                max2 -= l;
            }
            long L = i2.getNumberOfLiteralWords();
            int k2 = 0;
            while ((long)k2 < L) {
                c2.addWord(i2.getLiteralWordAt(k2));
                ++k2;
            }
        } while (max2 > 0 && i2.next());
        return origMax - max2;
    }

    public static EWAHCompressedBitmap32 materialize(IteratingRLW32 i2) {
        EWAHCompressedBitmap32 ewah = new EWAHCompressedBitmap32();
        IteratorUtil32.materialize(i2, ewah);
        return ewah;
    }
}

