/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.CloneableIterator;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.EWAHIterator32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.IteratorAggregation32;
import com.googlecode.javaewah32.XORIt;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

class ORIt
implements CloneableIterator<EWAHIterator32> {
    final EWAHCompressedBitmap32 buffer = new EWAHCompressedBitmap32();
    final int[] hardBitmap;
    final LinkedList<IteratingRLW32> ll;

    ORIt(LinkedList<IteratingRLW32> basell, int bufSize) {
        this.ll = basell;
        this.hardBitmap = new int[bufSize];
    }

    public XORIt clone() throws CloneNotSupportedException {
        XORIt answer = (XORIt)super.clone();
        answer.buffer = this.buffer.clone();
        answer.hardbitmap = (int[])this.hardBitmap.clone();
        answer.ll = (LinkedList)this.ll.clone();
        return answer;
    }

    @Override
    public boolean hasNext() {
        return !this.ll.isEmpty();
    }

    @Override
    public EWAHIterator32 next() {
        this.buffer.clear();
        int effective = 0;
        Iterator i2 = this.ll.iterator();
        while (i2.hasNext()) {
            IteratingRLW32 rlw = (IteratingRLW32)i2.next();
            if (rlw.size() > 0) {
                int eff = IteratorAggregation32.inplaceor(this.hardBitmap, rlw);
                if (eff <= effective) continue;
                effective = eff;
                continue;
            }
            i2.remove();
        }
        for (int k2 = 0; k2 < effective; ++k2) {
            this.buffer.addWord(this.hardBitmap[k2]);
        }
        Arrays.fill(this.hardBitmap, 0);
        return this.buffer.getEWAHIterator();
    }
}

