/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32.symmetric;

import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.symmetric.EWAHPointer32;
import com.googlecode.javaewah32.symmetric.UpdateableBitmapFunction32;
import java.util.Arrays;

public final class ThresholdFuncBitmap32
extends UpdateableBitmapFunction32 {
    private final int min;
    private int[] buffers;
    private int bufferUsed;
    private final int[] bufcounters = new int[64];
    private static final int[] zeroes64 = new int[64];

    public ThresholdFuncBitmap32(int min2) {
        this.min = min2;
        this.buffers = new int[16];
        this.bufferUsed = 0;
    }

    @Override
    public void dispatch(BitmapStorage32 out2, int runBegin, int runend) {
        int runLength = runend - runBegin;
        if (this.hammingWeight >= this.min) {
            out2.addStreamOfEmptyWords(true, runLength);
        } else if (this.litWeight + this.hammingWeight < this.min) {
            out2.addStreamOfEmptyWords(false, runLength);
        } else {
            int deficit = this.min - this.hammingWeight;
            if (deficit == 1) {
                this.orLiterals(out2, runBegin, runLength);
                return;
            }
            this.bufferUsed = this.getNumberOfLiterals();
            if (this.bufferUsed == deficit) {
                this.andLiterals(out2, runBegin, runLength);
            } else {
                this.generalLiterals(deficit, out2, runBegin, runLength);
            }
        }
    }

    private int threshold2buf(int t2, int[] buf, int bufUsed) {
        int result2 = 0;
        int[] counters = this.bufcounters;
        System.arraycopy(zeroes64, 0, counters, 0, 64);
        for (int k2 = 0; k2 < bufUsed; ++k2) {
            int t22;
            for (int bitset = buf[k2]; bitset != 0; bitset ^= t22) {
                t22 = bitset & -bitset;
                int n = Integer.bitCount(t22 - 1);
                counters[n] = counters[n] + 1;
            }
        }
        for (int pos = 0; pos < 64; ++pos) {
            if (counters[pos] < t2) continue;
            result2 = (int)((long)result2 | 1L << pos);
        }
        return result2;
    }

    private static int threshold3(int t2, int[] buffers, int bufUsed) {
        if (buffers.length == 0) {
            return 0;
        }
        int[] v = new int[t2];
        v[0] = buffers[0];
        for (int k2 = 1; k2 < bufUsed; ++k2) {
            int m4;
            int c2 = buffers[k2];
            for (int j2 = m4 = Math.min(t2 - 1, k2); j2 >= 1; --j2) {
                int n = j2;
                v[n] = v[n] | c2 & v[j2 - 1];
            }
            v[0] = v[0] | c2;
        }
        return v[t2 - 1];
    }

    private int threshold4(int t2, int[] buf, int bufUsed) {
        if (t2 >= 128) {
            return this.threshold2buf(t2, buf, bufUsed);
        }
        int b2 = 0;
        for (int k2 = 0; k2 < bufUsed; ++k2) {
            b2 += Integer.bitCount(buf[k2]);
        }
        if (2 * b2 >= bufUsed * t2) {
            return ThresholdFuncBitmap32.threshold3(t2, buf, bufUsed);
        }
        return this.threshold2buf(t2, buf, bufUsed);
    }

    private void orLiterals(BitmapStorage32 out2, int runBegin, int runLength) {
        for (int i2 = 0; i2 < runLength; ++i2) {
            int w = 0;
            for (EWAHPointer32 r : this.getLiterals()) {
                w |= r.iterator.getLiteralWordAt(i2 + runBegin - r.beginOfRun());
            }
            out2.addWord(w);
        }
    }

    private void andLiterals(BitmapStorage32 out2, int runBegin, int runLength) {
        for (int i2 = 0; i2 < runLength; ++i2) {
            int w = -1;
            for (EWAHPointer32 r : this.getLiterals()) {
                w &= r.iterator.getLiteralWordAt(i2 + runBegin - r.beginOfRun());
            }
            out2.addWord(w);
        }
    }

    private void generalLiterals(int deficit, BitmapStorage32 out2, int runBegin, int runLength) {
        if (this.bufferUsed > this.buffers.length) {
            this.buffers = Arrays.copyOf(this.buffers, 2 * this.bufferUsed);
        }
        for (int i2 = 0; i2 < runLength; ++i2) {
            int p = 0;
            for (EWAHPointer32 r : this.getLiterals()) {
                this.buffers[p++] = r.iterator.getLiteralWordAt(i2 + runBegin - r.beginOfRun());
            }
            out2.addWord(this.threshold4(deficit, this.buffers, this.bufferUsed));
        }
    }
}

