/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.internal.JsonContext;
import com.jayway.jsonpath.internal.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ParseContextImpl
implements ParseContext {
    private final Configuration configuration;

    public ParseContextImpl() {
        this(Configuration.defaultConfiguration());
    }

    public ParseContextImpl(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public DocumentContext parse(Object json2) {
        Utils.notNull(json2, "json object can not be null");
        return new JsonContext(json2, this.configuration);
    }

    @Override
    public DocumentContext parse(String json2) {
        Utils.notEmpty(json2, "json string can not be null or empty");
        Object obj = this.configuration.jsonProvider().parse(json2);
        return new JsonContext(obj, this.configuration);
    }

    @Override
    public DocumentContext parseUtf8(byte[] json2) {
        Utils.notEmpty(json2, "json bytes can not be null or empty");
        Object obj = this.configuration.jsonProvider().parse(json2);
        return new JsonContext(obj, this.configuration);
    }

    @Override
    public DocumentContext parse(InputStream json2) {
        return this.parse(json2, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentContext parse(InputStream json2, String charset) {
        Utils.notNull(json2, "json input stream can not be null");
        Utils.notNull(charset, "charset can not be null");
        try {
            Object obj = this.configuration.jsonProvider().parse(json2, charset);
            JsonContext jsonContext = new JsonContext(obj, this.configuration);
            return jsonContext;
        }
        finally {
            Utils.closeQuietly(json2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentContext parse(File json2) throws IOException {
        DocumentContext documentContext;
        Utils.notNull(json2, "json file can not be null");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(json2);
            documentContext = this.parse(fis);
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(fis);
            throw throwable;
        }
        Utils.closeQuietly(fis);
        return documentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public DocumentContext parse(URL url2) throws IOException {
        Utils.notNull(url2, "url can not be null");
        InputStream fis = null;
        try {
            fis = url2.openStream();
            DocumentContext documentContext = this.parse(fis);
            return documentContext;
        }
        finally {
            Utils.closeQuietly(fis);
        }
    }
}

