/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.internal.EvaluationAbortException;
import com.jayway.jsonpath.internal.EvaluationContext;
import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.function.ParamType;
import com.jayway.jsonpath.internal.function.Parameter;
import com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import com.jayway.jsonpath.internal.path.FunctionPathToken;
import com.jayway.jsonpath.internal.path.PathToken;
import com.jayway.jsonpath.internal.path.RootPathToken;
import com.jayway.jsonpath.internal.path.ScanPathToken;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledPath
implements Path {
    private static final Logger logger = LoggerFactory.getLogger(CompiledPath.class);
    private final RootPathToken root;
    private final boolean isRootPath;

    public CompiledPath(RootPathToken root, boolean isRootPath) {
        this.root = this.invertScannerFunctionRelationship(root);
        this.isRootPath = isRootPath;
    }

    @Override
    public boolean isRootPath() {
        return this.isRootPath;
    }

    private RootPathToken invertScannerFunctionRelationship(RootPathToken path2) {
        if (path2.isFunctionPath() && path2.next() instanceof ScanPathToken) {
            PathToken token2 = path2;
            PathToken prior = null;
            while (null != (token2 = token2.next()) && !(token2 instanceof FunctionPathToken)) {
                prior = token2;
            }
            if (token2 instanceof FunctionPathToken) {
                prior.setNext(null);
                path2.setTail(prior);
                Parameter parameter = new Parameter();
                parameter.setPath(new CompiledPath(path2, true));
                parameter.setType(ParamType.PATH);
                ((FunctionPathToken)token2).setParameters(Arrays.asList(parameter));
                RootPathToken functionRoot = new RootPathToken('$');
                functionRoot.setTail(token2);
                functionRoot.setNext(token2);
                return functionRoot;
            }
        }
        return path2;
    }

    @Override
    public EvaluationContext evaluate(Object document, Object rootDocument, Configuration configuration, boolean forUpdate) {
        if (logger.isDebugEnabled()) {
            logger.debug("Evaluating path: {}", (Object)this.toString());
        }
        EvaluationContextImpl ctx = new EvaluationContextImpl(this, rootDocument, configuration, forUpdate);
        try {
            PathRef op = ctx.forUpdate() ? PathRef.createRoot(rootDocument) : PathRef.NO_OP;
            this.root.evaluate("", op, document, ctx);
        }
        catch (EvaluationAbortException evaluationAbortException) {
            // empty catch block
        }
        return ctx;
    }

    @Override
    public EvaluationContext evaluate(Object document, Object rootDocument, Configuration configuration) {
        return this.evaluate(document, rootDocument, configuration, false);
    }

    @Override
    public boolean isDefinite() {
        return this.root.isPathDefinite();
    }

    @Override
    public boolean isFunctionPath() {
        return this.root.isFunctionPath();
    }

    public String toString() {
        return this.root.toString();
    }

    public RootPathToken getRoot() {
        return this.root;
    }
}

