/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.function.Parameter;
import com.jayway.jsonpath.internal.path.ArrayIndexOperation;
import com.jayway.jsonpath.internal.path.ArrayIndexToken;
import com.jayway.jsonpath.internal.path.ArraySliceOperation;
import com.jayway.jsonpath.internal.path.ArraySliceToken;
import com.jayway.jsonpath.internal.path.FunctionPathToken;
import com.jayway.jsonpath.internal.path.PathToken;
import com.jayway.jsonpath.internal.path.PredicatePathToken;
import com.jayway.jsonpath.internal.path.PropertyPathToken;
import com.jayway.jsonpath.internal.path.RootPathToken;
import com.jayway.jsonpath.internal.path.ScanPathToken;
import com.jayway.jsonpath.internal.path.WildcardPathToken;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PathTokenFactory {
    public static RootPathToken createRootPathToken(char token2) {
        return new RootPathToken(token2);
    }

    public static PathToken createSinglePropertyPathToken(String property2, char stringDelimiter) {
        return new PropertyPathToken(Collections.singletonList(property2), stringDelimiter);
    }

    public static PathToken createPropertyPathToken(List<String> properties, char stringDelimiter) {
        return new PropertyPathToken(properties, stringDelimiter);
    }

    public static PathToken createSliceArrayPathToken(ArraySliceOperation arraySliceOperation) {
        return new ArraySliceToken(arraySliceOperation);
    }

    public static PathToken createIndexArrayPathToken(ArrayIndexOperation arrayIndexOperation) {
        return new ArrayIndexToken(arrayIndexOperation);
    }

    public static PathToken createWildCardPathToken() {
        return new WildcardPathToken();
    }

    public static PathToken crateScanToken() {
        return new ScanPathToken();
    }

    public static PathToken createPredicatePathToken(Collection<Predicate> predicates) {
        return new PredicatePathToken(predicates);
    }

    public static PathToken createPredicatePathToken(Predicate predicate) {
        return new PredicatePathToken(predicate);
    }

    public static PathToken createFunctionPathToken(String function, List<Parameter> parameters2) {
        return new FunctionPathToken(function, parameters2);
    }
}

